<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Description of Mailboxes
 *
 * @author inbs
 */
class MailboxRead extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\MailboxRead";
    }
    public function getReceiveMessageListTableQuery($data)
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "id");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $meilboxId = array_get($data, "meilboxId", NULL);
        $searchByField = ["date" => array_get($data, "params.search.predicateObject.date", false), "email" => array_get($data, "params.search.predicateObject.email", false), "from_email" => array_get($data, "params.search.predicateObject.from_email", false), "title" => array_get($data, "params.search.predicateObject.title", false), "resource_id" => array_get($data, "params.search.predicateObject.resource_id", false)];
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $query = $this->getModel()->with(["mailbox", "resource"]);
        if($meilboxId !== NULL) {
            $query = $query->where("mail_configuration_id", "LIKE", $meilboxId);
        }
        $query = $query->where(function ($query) use($query) {
            $isFirst = true;
            foreach ($searchByField as $field => $search) {
                if($isFirst && $search !== false) {
                    $query = $query->where($field, "LIKE", "%" . $search . "%");
                } elseif(!$isFirst && $search !== false) {
                    $query = $query->orWhere($field, "LIKE", "%" . $search . "%");
                }
            }
        });
        if(!empty($searchGlobal)) {
            $query = $query->searchGlobal($searchGlobal);
        }
        $total = $query->count();
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        foreach ($results as $key => &$result) {
            $mailboxid = $result->mail_configuration_id;
            $mail_read_id = $result->id;
            $attachment = \mgCRM2\Models\Attachment::where("mailbox_id", $mailboxid)->where("mail_read_id", $mail_read_id)->get();
            if($attachment) {
                $attachment = $attachment->toArray();
                foreach ($attachment as &$attach) {
                    $attach["attachment"] = $attach["attachment"];
                    $attach["filename"] = \mgCRM2\Helpers\AttachmentsHelper::parseFileNameToDisplay($attach["filename"]);
                }
                $result->attachment = $attachment;
            }
            $result->content = strip_tags($result->content, "<a><b><img>");
        }
        $return = ["data" => $results->toArray(), "total" => $total];
        return $return;
    }
    public function sendMessage($data = [])
    {
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $from = array_get($data, "from", NULL);
        $to = array_get($data, "to", NULL);
        $templateId = array_get($data, "template_id", NULL);
        $subject = array_get($data, "subject", NULL);
        $message = nl2br(array_get($data, "message", NULL));
        $mailBoxId = array_get($data, "mailBoxId", NULL);
        if(!\mgCRM2\Models\Validators\Common::isValidEmail($to)) {
            throw new \Exception(sprintf("Email (%s) is not valid", $to));
        }
        if(!\mgCRM2\Models\Validators\Common::isValidEmail($from)) {
            throw new \Exception(sprintf("Email (%s) is not valid", $from));
        }
        $smartyVariables = [];
        if(\mgCRM2\Models\Validators\Common::isPositiveNumber($templateId) && $templateId != 0) {
            $mailer = mgCRM_getMailerInstance();
            $result = $mailer->sentRawEmailFromTemplate($from, $to, $templateId, $smartyVariables, ["is_global_config" => false, "department_id" => $mailBoxId, "mailbox_id" => $mailBoxId]);
        } else {
            $mailer = mgCRM_getMailerInstance();
            $result = $mailer->sentEmailFromRawData($from, $to, $subject, $message, [], $smartyVariables, ["is_global_config" => false, "department_id" => $mailBoxId, "mailbox_id" => $mailBoxId]);
        }
        return $result;
    }
    public function removeMessage($id, $mailboxId)
    {
        $mailRecive = new \mgCRM2\Services\MailerReceive($mailboxId);
        $mailRecive->removeEmail($id);
    }
    public function deleteAllMessagesFromMailbox($id)
    {
        $this->model->where("mail_configuration_id", $id)->delete();
    }
}

?>