<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Description of Mailboxes
 *
 * @author inbs
 */
class Mailboxes extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Mailbox";
    }
    public function createMailbox(array $data = [])
    {
        $parsed = ["name" => array_get($data, "name", ""), "description" => array_get($data, "description", ""), "email" => array_get($data, "email", ""), "SMTPHost" => array_get($data, "server", ""), "SMTPUsername" => array_get($data, "username", ""), "SMTPPassword" => base64_encode(array_get($data, "password", "")), "SMTPSSL" => array_get($data, "encryption", "0"), "SMTPPort" => array_get($data, "port", ""), "MailEncoding" => array_get($data, "mailencoding", "0"), "receive_method" => array_get($data, "receive_method", "pop3"), "receive_port" => array_get($data, "receive_port", NULL), "receive_folder" => array_get($data, "receive_folder", "INBOX"), "receive_ssl" => array_get($data, "receive_ssl", []), "receive_server" => array_get($data, "receive_server", ""), "admin_id" => array_get($data, "admin_id.id", "0")];
        $new = new \mgCRM2\Models\Mailbox($parsed);
        $new->save();
        return $new;
    }
    public function updateMailbox($id, array $data = [])
    {
        $mailbox = $this->getModel()->find($id);
        if(is_null($mailbox)) {
            throw new \Exception("Mailbox not found");
        }
        $parsed = ["name" => array_get($data, "name", ""), "description" => array_get($data, "description", ""), "email" => array_get($data, "email", ""), "SMTPHost" => array_get($data, "SMTPHost", ""), "SMTPUsername" => array_get($data, "SMTPUsername", ""), "SMTPSSL" => array_get($data, "SMTPSSL", "0"), "SMTPPort" => array_get($data, "SMTPPort", ""), "MailEncoding" => array_get($data, "MailEncoding", "0"), "receive_method" => array_get($data, "receive_method", "pop3"), "receive_port" => array_get($data, "receive_port", NULL), "receive_folder" => array_get($data, "receive_folder", "INBOX"), "receive_ssl" => array_get($data, "receive_ssl", []), "receive_server" => array_get($data, "receive_server", ""), "admin_id" => array_get($data, "admin_id.id", "0")];
        $password = array_get($data, "password", "");
        if($password != "") {
            $parsed["SMTPPassword"] = base64_encode($password);
        }
        $mailbox->fill($parsed);
        $mailbox->save();
        return $mailbox;
    }
    public function deleteMailbox($id)
    {
        $found = $this->getModel()->where("id", "=", $id)->first();
        if(is_null($found)) {
            throw new \Exception(sprintf("Couldn't find Mailbox #%d", $id));
        }
        return $found->delete();
    }
    public function getMailbox($id)
    {
        $mailbox = $this->getModel()->joinAdminRelevant()->find($id);
        if(is_null($mailbox)) {
            throw new \Exception("Mailbox not found");
        }
        return $mailbox;
    }
    public function getMailboxByAdmin($adminId)
    {
        $model = $this->getModel();
        if($adminId != 0) {
            $model = $model->whereAdminId($adminId);
        }
        $mailbox = $model->get();
        if(is_null($mailbox)) {
            throw new \Exception("Mailbox not found");
        }
        return $mailbox;
    }
    public function testMail($mailboxId)
    {
        $mailbox = $this->getMailbox($mailboxId)->toArray();
        $app = \mgCRM2\Integration\Slim\SlimApp::getInstance();
        $from = $mailbox["email"];
        $to = $app->currentAdmin->email;
        $addtional = ["resource_id" => NULL, "is_global_config" => false, "department_id" => $mailbox["id"]];
        $message = NULL;
        try {
            $mailer = mgCRM_getMailerInstance();
            $result = $mailer->sentEmailFromRawData($from, $to, "WHMCS CRM - Test Connection", "<h1>Test Connection with WHMCS CRM</h1>", [], $app->currentAdmin->toArray(), $addtional);
        } catch (\Exception $ex) {
            $message = $e->getMessage();
            $result = false;
        }
        $return = ["return" => $result, "error" => $message, "email" => $to];
        return $return;
    }
    public function syncCampaignResourcesByFilters($id)
    {
        $campaign = $this->getModel()->find($id);
        if(is_null($campaign)) {
            throw new \Exception("Campaign not found");
        }
        $resourcesIDs = $this->filterResourcesForCampaign($campaign->filters);
        if(!empty($resourcesIDs)) {
            $campaign->resources()->sync($resourcesIDs);
        }
        return true;
    }
    public function ResourcesTableQueryByFilters(array $data = [], $showHidden = false)
    {
        return $this->filterResources($data, false);
    }
    public function filterResourcesForCampaign($data)
    {
        $parsedData = ["search" => $data];
        return $this->filterResources($parsedData, true);
    }
    public function parseSearchByFilters($data)
    {
        $filter = function ($array) {
            $return = [];
            foreach ($array as $sName => $sVal) {
                if(array_get($sVal, "enabled", false)) {
                    $sName = is_numeric($sName) ? "field_" . $sName : $sName;
                    $return[$sName] = isset($sVal["value"]) ? $sVal["value"] : "";
                }
            }
            return $return;
        };
        $return = $filter(array_get($data, "static", [])) + $filter(array_get($data, "dynamic", []));
        $return = array_filter($return);
        return $return;
    }
    public function getMailboxListTableQuery($data)
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "id");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $name = array_get($data, "params.search.predicateObject.name", false);
        $description = array_get($data, "params.search.predicateObject.description", false);
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $query = $this->getModel()->joinAdminRelevant();
        if(!empty($name)) {
            $query = $query->whereName($name);
        }
        if(!empty($description)) {
            $query = $query->whereDescription($description);
        }
        if(!empty($searchGlobal)) {
            $query = $query->searchGlobal($searchGlobal);
        }
        $total = $query->count();
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        $return = ["data" => $results->toArray(), "total" => $total];
        return $return;
    }
    public function getCampaignsForAPI()
    {
        return $this->getModel()->withResourcesCount()->withAdmins()->get()->toArray();
    }
}

?>