<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Orders
 * as repository pattern
 */
class Orders extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Whmcs\\Order";
    }
    public function parseForTable($resourceID, array $data = [])
    {
        $resource = \mgCRM2\Models\Resource::withTrashed()->findOrFail($resourceID);
        $client = \mgCRM2\Models\Whmcs\Client::findOrFail($resource->client_id);
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "id");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $message = array_get($data, "params.search.predicateObject.message", false);
        $date = array_get($data, "params.search.predicateObject.date", false);
        $admin_id = array_get($data, "params.search.predicateObject.admin_id", false);
        $event = array_get($data, "params.search.predicateObject.event", false);
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $searchColumn = ["id" => array_get($data, "params.search.predicateObject.id", false), "ordernum" => array_get($data, "params.search.predicateObject.ordernum", false), "date" => array_get($data, "params.search.predicateObject.date", false), "amount" => array_get($data, "params.search.predicateObject.amount", false), "status" => array_get($data, "params.search.predicateObject.status", false), "paymentmethod" => array_get($data, "params.search.predicateObject.paymentmethod", false), "invoicestatus" => array_get($data, "params.search.predicateObject.invoicestatus", false), "invoiceid" => array_get($data, "params.search.predicateObject.invoiceid", false)];
        $query = $this->getModel()->where("tblorders.userid", "=", $client->id)->leftJoin("tblpaymentgateways", function ($join) {
            $join->on("tblpaymentgateways.gateway", "=", "tblorders.paymentmethod")->on("tblpaymentgateways.setting", "=", \Illuminate\Database\Capsule\Manager::raw("'name'"));
        })->leftJoin("tblinvoices", function ($join) {
            $join->on("tblinvoices.id", "=", "tblorders.invoiceid");
        })->leftJoin("tblclients", function ($join) {
            $join->on("tblorders.userid", "=", "tblclients.id");
        })->addSelect(["tblorders.id as id", "tblorders.ordernum as ordernum", "tblorders.userid as userid", "tblorders.contactid as contactid", "tblorders.date as date", "tblorders.amount as amount", "tblorders.paymentmethod as paymentmethod", "tblorders.invoiceid as invoiceid", "tblorders.status as status", "tblorders.notes as notes", "tblpaymentgateways.value as gateway", "tblinvoices.status as invoicestatus", "tblclients.currency as currency"]);
        foreach ($searchColumn as $column => $val) {
            if(!empty($val) && $val !== false) {
                if($column == "paymentmethod") {
                    $prefix = "tblpaymentgateways.value";
                } elseif($column == "invoicestatus") {
                    $prefix = "tblinvoices.status";
                } elseif($column == "invoiceid") {
                    $prefix = "tblinvoices.id";
                } else {
                    $prefix = "tblorders." . $column;
                }
                $query = $query->where($prefix, "LIKE", "%" . $val . "%");
            }
        }
        if(!empty($searchGlobal) && $searchGlobal !== false) {
            $query = $query->where(function ($query) {
                foreach (["tblorders.id", "tblorders.ordernum", "tblorders.date", "tblorders.amount", "tblpaymentgateways.value", "tblorders.status", "tblinvoices.status", "tblorders.invoiceid"] as $c) {
                    $query->orWhere($c, "LIKE", "%" . $searchGlobal . "%");
                }
            });
        }
        $total = $query->count();
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset)->get();
        include_whmcs();
        foreach ($results as &$order) {
            $order->amount = formatCurrency($order->amount, $order->currency)->toFull();
        }
        $return = ["data" => $results->toArray(), "total" => $total];
        return $return;
    }
}

?>