<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
/**
 * Repository pattern for Reminders
 * Wrap certain actions for collection of our model or perform more complexed actions on model
 */
class Reminders extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\Reminder";
    }
    public static function recalculateDateByType($when, \Carbon\Carbon $followupDate, $data = NULL)
    {
        if($when == "for_date") {
            $date = $followupDate;
        } elseif($when == "before_date") {
            $date = $followupDate;
            $ofset = intval(array_get($data, "amount", 0));
            if(array_get($data, "before") == "days") {
                $date->subDays($ofset);
            } elseif(array_get($data, "before") == "hours") {
                $date->subHours($ofset);
            } else {
                $date->subMinutes($ofset);
            }
        } else {
            $date = \Carbon\Carbon::now();
        }
        return $date;
    }
    public static function createAdminEmailRemidner(\mgCRM2\Models\Followup $followup, $when, array $data = [])
    {
        return self::createEmailRemidner($followup, "admin", "email", $when, $data);
    }
    public static function createAdminSmsRemidner(\mgCRM2\Models\Followup $followup, $when, array $data = [])
    {
        return self::createEmailRemidner($followup, "admin", "sms", $when, $data);
    }
    public static function createClientEmailRemidner(\mgCRM2\Models\Followup $followup, $when, array $data = [])
    {
        return self::createEmailRemidner($followup, "client", "email", $when, $data);
    }
    public static function createClientSmsRemidner(\mgCRM2\Models\Followup $followup, $when, array $data = [])
    {
        return self::createEmailRemidner($followup, "client", "sms", $when, $data);
    }
    public static function createEmailRemidner(\mgCRM2\Models\Followup $followup, $targetType = "admin", $reminderType = "email", $when = NULL, array $data = [], $customData = false)
    {
        try {
            $template = \mgCRM2\Models\Whmcs\EmailTemplates::findOrFail(array_get($data, "template"));
            if($targetType == "client") {
                $targetID = $followup->resource_id;
                $targetCheckedType = "resource";
            } else {
                $targetID = \mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->findOrFail(array_get($data, "admin"))->id;
                $targetCheckedType = "admin";
            }
            $cc = array_get($data, "cc", NULL);
            if($customData !== false && $customData instanceof \Carbon\Carbon) {
                $date = self::recalculateDateByType($when, $customData);
            } else {
                $date = self::recalculateDateByType($when, $followup->date, $data);
            }
            $reminder = new \mgCRM2\Models\Reminder(["followup_id" => $followup->id, "template_id" => $template->id, "target" => $targetCheckedType, "target_id" => $targetID, "date" => $date, "cc" => array_get($data, "cc", NULL), "bcc" => array_get($data, "bcc", NULL), "reply" => array_get($data, "reply", NULL), "type" => $reminderType == "sms" ? "sms" : "email", "status" => "pending"]);
            return $reminder;
        } catch (\Exception $ex) {
            \mgCRM2\Integration\Slim\SlimApp::getInstance()->log->error($e);
            return false;
        }
    }
    public function getForResourceAndFollowup($resourceID, $followupID)
    {
        return $this->getModel()->forFollowupResource($resourceID, $followupID)->get();
    }
    public function getForResourceAndFollowupAndReminder($resourceID, $followupID, $reminderID)
    {
        return $this->getModel()->where("id", "=", $reminderID)->forFollowupResource($resourceID, $followupID)->get();
    }
    public function parseForTableForResourceAndFollowupAndReminder($resourceID, $followupID, array $data = [])
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $ofset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "date");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $description = array_get($data, "params.search.predicateObject.description", false);
        $type = array_get($data, "params.search.predicateObject.type", false);
        $status = array_get($data, "params.search.predicateObject.status", false);
        $search_id = array_get($data, "params.search.predicateObject.id", false);
        $search_date = array_get($data, "params.search.predicateObject.date", false);
        $query = $this->getModel()->forFollowupResource($resourceID, $followupID);
        $queryTotal = clone $query;
        $query = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($ofset);
        if(!empty($description) && $description !== false) {
            $query = $query->withDescription($description);
            $queryTotal = $queryTotal->withDescription($description);
        }
        if(!empty($search_id) && $search_id !== false) {
            $query = $query->where("id", "=", $search_id);
            $queryTotal = $queryTotal->where("id", "=", $search_id);
        }
        if(!empty($type) && $type !== false) {
            $query = $query->where("type", "=", $type);
            $queryTotal = $queryTotal->where("type", "=", $type);
        }
        if(!empty($status) && $status !== false) {
            $query = $query->where("status", "=", $status);
            $queryTotal = $queryTotal->where("status", "=", $status);
        }
        if(!empty($search_date) && $search_date !== false) {
            $query = $query->where("date", "like", "%" . $search_date . "%");
            $queryTotal = $queryTotal->where("id", "like", "%" . $search_date . "%");
        }
        $results = $query->get();
        $count = $queryTotal->count();
        $return = ["data" => $results->toArray(), "total" => $count];
        return $return;
    }
    public function createSingleReminder($resourceID, $followupID, $requestData)
    {
        $followup = \mgCRM2\Models\Followup::findOrFail($followupID);
        if($followup->resource_id != (int) $resourceID) {
            throw new \Exception(sprintf("Follow-up does not belong to resource #%s", $resourceID));
        }
        $data = [];
        $reminderType = array_get($requestData, "type", "email");
        if(in_array(array_get($requestData, "for", "admin"), ["admin", "client"])) {
            $targetType = array_get($requestData, "for", "admin");
            array_set($data, "admin", array_get($requestData, "target_id", NULL));
            if($reminderType == "email") {
                if(array_get($requestData, "email.cc", NULL) != NULL) {
                    array_set($data, "cc", array_get($requestData, "email.cc", NULL));
                }
                if(array_get($requestData, "email.bcc", NULL) != NULL) {
                    array_set($data, "bcc", array_get($requestData, "email.bcc", NULL));
                }
                if(array_get($requestData, "email.reply", NULL) != NULL) {
                    array_set($data, "reply", array_get($requestData, "email.reply", NULL));
                }
            }
            array_set($data, "template", array_get($requestData, "template_id", NULL));
            $configuredDate = \Carbon\Carbon::parse(array_get($requestData, "date", NULL));
            $reminder = self::createEmailRemidner($followup, $targetType, $reminderType, "for_date", $data, $configuredDate);
            $followup->reminders()->save($reminder);
            return $reminder;
        }
        throw new \Exception("Invalid Reminder Target");
    }
    public function updateSingleReminder($resourceID, $followupID, $reminderID, $requestData)
    {
        $reminder = \mgCRM2\Models\Reminder::forFollowupResource($resourceID, $followupID)->whereId($reminderID)->first();
        if(is_null($reminder)) {
            throw new \Exception(sprintf("Follow-up does noe belong to resource #%s", $resourceID));
        }
        $data = [];
        $template = \mgCRM2\Models\Whmcs\EmailTemplates::findOrFail(array_get($requestData, "template_id"));
        array_set($data, "template_id", $template->id);
        array_set($data, "type", array_get($requestData, "type", NULL));
        $targetType = array_get($requestData, "target", "admin");
        if(in_array($targetType, ["admin", "resource"])) {
            array_set($data, "target", $targetType);
            array_set($data, "target_id", array_get($requestData, "target_id", NULL));
            array_set($data, "cc", array_get($requestData, "cc", NULL));
            array_set($data, "reply", array_get($requestData, "reply", NULL));
            $configuredDate = \Carbon\Carbon::parse(array_get($requestData, "date", NULL));
            array_set($data, "date", $configuredDate->__toString());
            $reminder->fill($data)->save();
            return $reminder;
        }
        throw new \Exception("Invalid Reminder Target");
    }
    public function getFollowupReminders($followupID)
    {
        return $this->getModel()->forFollowup($followupID)->get();
    }
    public function cronGetRemindersToSent()
    {
        return $this->getModel()->pendingOrError()->beforeNow()->get();
    }
    public function deleteSingle($reminderID)
    {
        $reminder = $this->getModel()->findOrFail($reminderID);
        return $reminder->forceDelete();
    }
}

?>