<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

/**
 * Just container for Resource Types
 * as repository pattern
 */
class ResourceTypes extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\ResourceType";
    }
    public function getOrderred()
    {
        return $this->getModel()->orderBy("order", "ASC")->get();
    }
    public function updateSingleParamInModel($id, $data)
    {
        $model = $this->getModel()->find($id);
        if(!$model) {
            throw new \Exception("Couldnt find contact type with id " . $id);
        }
        if(!$model->updateSingleParam($data)) {
            throw new \Exception("Something went wrong");
        }
        return $model;
    }
    public function reorder(array $newOrder)
    {
        if(empty($newOrder)) {
            throw new \Exception("Wrong order parameters provided");
        }
        $groups = $this->model->all();
        foreach ($groups as $group) {
            $group->order = array_get($newOrder, $group->id, 0);
            $group->save();
        }
        return true;
    }
    public static function getForNavigation()
    {
        $return = ["navigation" => [], "submenu" => [], "routing" => []];
        $list = \mgCRM2\Models\ResourceType::orderred()->withTrashed()->get();
        foreach ($list as $type) {
            if($type->active && $type->trashed() === false) {
                if($type->isVisibleInNavbar()) {
                    $return["navigation"][] = $type->toNavigationArray();
                }
                if($type->isVisibleInNavbarSubmenu()) {
                    $return["submenu"][] = $type->toNavigationArray();
                }
            }
            $return["routing"][] = $type->toRoutingArray();
        }
        return $return;
    }
    public function convertOrDelete($data)
    {
        $model = \mgCRM2\Models\ResourceType::find(array_get($data, "id", false));
        if(is_null($model)) {
            throw new \Exception("Invalid Contact Type");
        }
        if(array_get($data, "archive", false) === true) {
            \Illuminate\Database\Capsule\Manager::table("crm_resources")->where("type_id", "=", $model->id)->update(["deleted_at" => \Illuminate\Database\Capsule\Manager::raw("NOW()")]);
        }
        $convert = \mgCRM2\Models\ResourceType::find(array_get($data, "convert", false));
        if($convert && $convert->id) {
            \Illuminate\Database\Capsule\Manager::table("crm_resources")->where("type_id", "=", $model->id)->update(["type_id" => $convert->id]);
        }
        $nameType = str_replace(" ", "_", strtolower($model->name));
        foreach (\mgCRM2\Models\PermissionRole::all() as $permission) {
            $leads = $permission->allowed;
            if(isset($leads) && isset($leads["leads"]) && isset($leads["leads"][$nameType])) {
                unset($leads["leads"][$nameType]);
                $permission->setAllowedAttribute($leads);
                $permission->save();
            }
        }
        return $model->delete();
    }
}

?>