<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories\Source;

abstract class AbstractRepository
{
    /**
     * Container for created model object
     * 
     * @var
     */
    protected $model;
    public function determinateModel();
    public function __construct()
    {
        $this->makeModel();
    }
    public function getModel()
    {
        return $this->model;
    }
    public function makeModel()
    {
        $this->model = $this->determinateModel();
        $this->model = new $this->model();
        if(!$this->model instanceof \Illuminate\Database\Eloquent\Model) {
            throw new RepositoryException("Class " . $this->model() . " must be an instance of Illuminate\\Database\\Eloquent\\Model");
        }
        return $this->model;
    }
    public function all()
    {
        return $this->model->all();
    }
    public function delete($id)
    {
        return $this->model->find($id)->delete();
    }
    public function forceDelete($id)
    {
        return $this->model->find($id)->forceDelete();
    }
    public function find($id)
    {
        return $this->model->find($id);
    }
    public function orderBy($column, $direction = "ASC")
    {
        return $this->model->orderBy($column, $direction);
    }
    public function where($column, $operand, $value)
    {
        return $this->model->where($column, $operand, $value);
    }
    public function create(array $data)
    {
        return $this->model->create($data);
    }
}

?>