<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories\Source;

abstract class AbstractRepositoryWithOrder extends AbstractRepository
{
    public function reorder(array $newOrder)
    {
        if(empty($newOrder)) {
            throw new \Exception("Wrong order parameters provided");
        }
        $groups = $this->model->all();
        foreach ($groups as $group) {
            $group->order = array_get($newOrder, $group->id, 0);
            $group->save();
        }
        return true;
    }
    public function getOrderred()
    {
        return $this->getModel()->orderred()->get();
    }
    public function getHighestOrderNumber() : int
    {
        $highestOrder = $this->model->select("order")->orderBy("order", "DESC")->limit(1)->first();
        return (int) $highestOrder->order;
    }
    public function getNextOrderNumber() : int
    {
        $highestOrder = $this->getHighestOrderNumber();
        return ++$highestOrder;
    }
}

?>