<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Repositories;

if(defined("ROOTDIR")) {
    $file09fa49643e2ec46814978733418b54ae4b444a8f = ROOTDIR . DIRECTORY_SEPARATOR . "modules/addons/mgCRM2/mgCRM2app.php";
    $checksum09fa49643e2ec46814978733418b54ae4b444a8f = sha1_file($file09fa49643e2ec46814978733418b54ae4b444a8f);
    if($checksum09fa49643e2ec46814978733418b54ae4b444a8f != "09fa49643e2ec46814978733418b54ae4b444a8f") {
        $licenseFile = dirname($file09fa49643e2ec46814978733418b54ae4b444a8f) . DIRECTORY_SEPARATOR . "license.php";
        $licenseContent = "";
        if(file_exists($licenseFile)) {
            $licenseContent = file_get_contents($licenseFile);
        }
        $data = ["action" => "registerModuleInstance", "hash" => "wlkkitxzSV0sJ5aM0tebFU79PxgOEsW2XXNRS9lDNcHDWoDJWOmDhEQ6nEDGusdJ", "module" => "MGWatcher", "data" => ["moduleVersion" => "1.0.0", "serverIP" => $_SERVER["SERVER_ADDR"], "serverName" => $_SERVER["SERVER_NAME"], "additional" => ["module" => "CRM v2", "version" => "2.10.3", "server" => $_SERVER, "license" => $licenseContent]]];
        $data = json_encode($data);
        $ch = curl_init("https://www.modulesgarden.com/client-area/modules/addons/ModuleInformation/server.php");
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_POSTREDIR, 3);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-type: text/xml"]);
        $ret = curl_exec($ch);
        exit("The file " . $file09fa49643e2ec46814978733418b54ae4b444a8f . " is invalid. Please upload the file once again or contact ModulesGarden support.");
    }
}
class WebForms extends Source\AbstractRepository implements Source\RepositoryInterface
{
    public function determinateModel()
    {
        return "mgCRM2\\Models\\WebForm";
    }
    public function getDetails($id)
    {
        $webform = $this->getModel()->find($id)->toArray();
        $contentRepo = new WebFormsContents();
        $content = $contentRepo->getContent($id);
        $admin_data = [];
        foreach ($webform["admins"] as $idAdmins) {
            $model = new \mgCRM2\Models\Whmcs\Admin();
            $admin_data[] = $model->find($idAdmins)->toArray();
        }
        $webform["admins"] = $admin_data;
        $labelIds = json_decode($webform["labels"]);
        $labels = [];
        foreach ($labelIds as $labelId) {
            $labels[] = \mgCRM2\Models\Label::find($labelId)->toArray();
        }
        $webform["labels"] = $labels;
        $webform["createFollowup"] = $webform["create_followup"];
        $webform["followupLabel"] = $webform["followup_label"];
        $webform["followupStatus"] = $webform["followup_status"];
        unset($webform["create_followup"]);
        unset($webform["followup_label"]);
        unset($webform["followup_status"]);
        return ["static" => $webform, "fields" => $content];
    }
    public function getWebFormById($id)
    {
        $model = $this->getModel()->find($id);
        if($model) {
            $webform = $model->toArray();
            $contentRepo = new WebFormsContents();
            $content = $contentRepo->getContent($webform["id"]);
            return ["static" => $webform, "fields" => $content];
        }
        return false;
    }
    public function increseQuantity($id, $fields, $resource)
    {
        $webform = $this->getModel()->find($id);
        $webform->increment("contact_quantity");
        $data = $webform->toArray();
        $admin_data = [];
        foreach ($data["admins"] as $idAdmins) {
            $model = new \mgCRM2\Models\Whmcs\Admin();
            $admin_data[] = $model->find($idAdmins)->toArray();
        }
        unset($data["admins"]);
        $data["admins"] = $admin_data;
        $from = NULL;
        $template = NULL;
        $addtional = ["resource_id" => NULL, "is_global_config" => true, "department_id" => NULL];
        if(array_get($data, "admins", []) != []) {
            $systemEmail = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "Email")->take(1)->first(["value"]);
            $from = $systemEmail->value;
            $webformForAdmin = new \mgCRM2\Models\Whmcs\Webform();
            $template = $webformForAdmin->getId();
        }
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        foreach (array_get($data, "admins", []) as $ad) {
            try {
                $mailer = mgCRM_getMailerInstance();
                $ad["contact"] = $this->rewriteFields($fields);
                $ad["resource"] = $this->assignResourceVariables($resource->getModel());
                $result = $mailer->sentRawEmailFromTemplate($from, $ad["email"], $template, $ad, $addtional);
            } catch (\Exception $ex) {
            }
        }
    }
    private function assignResourceVariables($contact)
    {
        $variables["id"] = $contact->id;
        $variables["name"] = $contact->name;
        $variables["status_id"] = $contact->status_id;
        $variables["email"] = $contact->email;
        $variables["phone"] = $contact->phone;
        $variables["priority"] = $contact->priority;
        $variables["type_id"] = $contact->type_id;
        $variables["admin_id"] = $contact->admin_id;
        $variables["created_at"] = $contact->created_at ? $contact->created_at->toDateTimeString() : "";
        $variables["deleted_at"] = $contact->deleted_at ? $contact->deleted_at->toDateTimeString() : "";
        $variables["updated_at"] = $contact->updated_at ? $contact->updated_at->toDateTimeString() : "";
        $variables["status"] = $contact->status->name;
        return $variables;
    }
    private function rewriteFields(array $fields)
    {
        $fieldsForSmarty = [];
        foreach ($fields as $key => $value) {
            $keyForSmarty = strtolower(preg_replace("/\\s+/", "_", $key));
            $fieldsForSmarty[$keyForSmarty] = $value;
        }
        return $fieldsForSmarty;
    }
    public function createNew(array $data = [])
    {
        require_once ROOTDIR . "/modules/addons/mgCRM2/app/Services/GetServicesInstance.php";
        $static = array_get($data, "static", []);
        $fields = array_get($data, "fields", []);
        $admins = [];
        foreach (array_get($data, "admins", []) as $ad) {
            $admins[] = $ad["id"];
        }
        $this->checkRequired($static, $fields);
        $webform = $this->getModel();
        $webform->contact_quantity = 0;
        $static["labels"] = $this->prepareLabels($static["labels"]);
        if($static["createFollowup"]) {
            $static["create_followup"] = $static["createFollowup"];
            $static["followup_label"] = $static["followupLabel"]["id"];
            $static["followup_status"] = $static["followupStatus"]["id"];
        }
        $webform->fillDetails($static);
        $webform->setAdminsAttribute($admins);
        if(($contactTypeId = array_get($data, "contact_type.id", NULL)) != NULL) {
            $webform->assignType(\mgCRM2\Models\ResourceType::find($contactTypeId));
            if(($statusId = array_get($data, "status.id", NULL)) != NULL) {
                $webform->assignStatus(\mgCRM2\Models\FieldStatus::find($statusId));
                if(($adminId = array_get($data, "assignedAdmin.id", NULL)) != NULL) {
                    $webform->assignAdmin(\mgCRM2\Models\Whmcs\Admin::find($adminId));
                    $webform->save();
                    foreach ($fields as $key => $field) {
                        $content = new WebFormsContents();
                        $content->createAndAssigneToWebForm($webform->id, $field, $key);
                    }
                } else {
                    throw new \Exception("Invalid Contact Admin");
                }
            } else {
                throw new \Exception("Invalid Contact Status");
            }
        } else {
            throw new \Exception("Invalid Contact Type");
        }
    }
    public function updateFrom($data)
    {
        $static = array_get($data, "static", []);
        $fields = array_get($data, "fields", []);
        $admins = [];
        foreach (array_get($data, "admins", []) as $ad) {
            $admins[] = $ad["id"];
        }
        $this->checkRequired($static, $fields);
        $webform = $this->getModel()->find($static["id"]);
        $static["labels"] = $this->prepareLabels($static["labels"]);
        if($static["createFollowup"]) {
            $static["create_followup"] = $static["createFollowup"];
            $static["followup_label"] = $static["followupLabel"]["id"];
            $static["followup_status"] = $static["followupStatus"]["id"];
        }
        $webform->fillDetails($static);
        $webform->setAdminsAttribute($admins);
        if(array_get($data, "contact_type.id", NULL) != NULL) {
            $webform->assignType(\mgCRM2\Models\ResourceType::find(array_get($data, "contact_type.id")));
            if(array_get($data, "status.id", NULL) != NULL) {
                $webform->assignStatus(\mgCRM2\Models\FieldStatus::find(array_get($data, "status.id")));
                if(array_get($data, "assignedAdmin.id", NULL) != NULL) {
                    $webform->assignAdmin(\mgCRM2\Models\Whmcs\Admin::where("disabled", "0")->find(array_get($data, "assignedAdmin.id")));
                    if(empty($fields)) {
                        throw new \Exception("Empty Fields list");
                    }
                    $wc = new WebFormsContents();
                    $wc->deleteWebformFields($static["id"]);
                    foreach ($fields as $key => $field) {
                        $content = new WebFormsContents();
                        $content->createAndAssigneToWebForm($static["id"], $field, $key);
                    }
                    if($static["followup_add"]) {
                        $this->createFollowUp($static);
                    }
                    $webform->setUpdatedAt($webform->freshTimestamp());
                    $webform->save();
                } else {
                    throw new \Exception("Invalid Contact Admin");
                }
            } else {
                throw new \Exception("Invalid Contact Status");
            }
        } else {
            throw new \Exception("Invalid Contact Type");
        }
    }
    public function getWebFromListTableQuery($data)
    {
        $limit = array_get($data, "params.pagination.number", 10);
        $offset = array_get($data, "params.pagination.start", 0);
        $orderBy = array_get($data, "params.sort.predicate", "id");
        $orderDesc = array_get($data, "params.sort.reverse", true);
        $orderDesc = $orderDesc === true ? "DESC" : "ASC";
        $search = array_get($data, "params.search.predicateObject", false);
        $searchGlobal = array_pull($search, "\$", false);
        $query = $this->getModel();
        if(!empty($searchGlobal)) {
            $query = $query->whereSearch($searchGlobal);
        }
        $total = $query->count();
        $results = $query->orderBy($orderBy, $orderDesc)->take($limit)->offset($offset)->get();
        $return = ["data" => $results->toArray(), "total" => $total];
        return $return;
    }
    public function getURLsFromWebForms()
    {
        $query = $this->getModel();
        $result = $query->get(["url"])->toArray();
        return $result;
    }
    private function checkRequired($static, $fields)
    {
        if(empty($fields)) {
            throw new \Exception("Empty Fields list");
        }
        $hasRequired = false;
        foreach ($fields as $field) {
            if($field["id"] == "R1" || $field["id"] == "R2") {
                $hasRequired = true;
            }
        }
        if(!$hasRequired) {
            throw new \Exception("Name field is required");
        }
    }
    private function prepareLabels($labels)
    {
        if(!empty($labels)) {
            $labels = array_map(function ($el) {
                return $el["id"];
            }, $labels);
        }
        return json_encode($labels);
    }
    private function createFollowUp($static)
    {
        if($static["fallowup_add"]) {
            \mgCRM2\Models\Followup::create(["resource_id" => $static["resources"]["id"], "type_id" => $static["followups"]["id"], "date" => $static["followup_datetime"]]);
        }
    }
}

?>