<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

class Automation
{
    public static function addEvent($eventType, array $vars)
    {
        switch ($eventType) {
            case "onServiceSuspend":
                (new Automation())->serviceSuspend($eventType, $vars);
                break;
            case "onEmailSend":
                (new Automation())->emailSend($eventType, $vars);
                break;
            case "onInvoiceCreated":
                (new Automation())->invoiceCreated($eventType, $vars);
                break;
        }
    }
    private function serviceSuspend($eventType, array $vars)
    {
        if($this->eventCanBeCreated($eventType, (int) $vars["params"]["userid"])) {
            $eventsManager = new EventsManager(EventsManager::SERVICE_SUSPENDED, ["serviceId" => $vars["params"]["serviceid"]]);
            $eventsManager->create();
        }
    }
    private function emailSend($eventType, array $vars)
    {
        if($this->eventCanBeCreated($eventType, (int) $vars["mergefields"]["client_id"], $vars["messagename"]) && $vars["relid"]) {
            $eventsManager = new EventsManager(EventsManager::EMAIL_SENT, ["messageName" => $vars["messagename"], "relId" => $vars["relid"]]);
            $eventsManager->create();
        }
    }
    private function invoiceCreated($eventType, array $vars)
    {
        if($this->eventCanBeCreated($eventType, (int) $vars["user"])) {
            $eventsManager = new EventsManager(EventsManager::INVOICE_CREATED, ["invoiceId" => $vars["invoiceid"]]);
            $eventsManager->create();
        }
    }
    private function eventCanBeCreated($eventType, int $userId = NULL, $emailSentName)
    {
        if(is_null($userId) || $userId === 0) {
            return false;
        }
        $client = $this->clientExists($userId);
        $rule = \mgCRM2\Models\AutomationRules::checkIfRuleIsUsed($eventType);
        if($eventType === "onEmailSend") {
            $nameExist = $this->emailSentNameExist($emailSentName);
            return $client && $rule && $nameExist;
        }
        return $client && $rule;
    }
    private function clientExists($userId)
    {
        return \mgCRM2\Models\Resource::where("client_id", $userId)->first() !== NULL;
    }
    private function emailSentNameExist($emailSentName)
    {
        if(empty($emailSentName)) {
            return false;
        }
        $names = [];
        $data = \mgCRM2\Models\AutomationRules::where("rule", "onEmailSend")->pluck("data");
        $data->filter(function ($item) use($item) {
            $names[] = $item->type->name;
        });
        return in_array($emailSentName, $names);
    }
}

?>