<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

/**
 * Description of AutomationManager
 *
 * @author Rafał
 */
class AutomationManager
{
    /**
     *
     * @var Automations[] 
     */
    protected $automations;
    public function __construct()
    {
        $this->automations = \mgCRM2\Models\Automations::onlyActive()->with("rules")->get();
    }
    public function execute()
    {
        foreach ($this->automations as $automation) {
            $this->executeRules($automation->rules);
        }
    }
    protected function executeRules($rules, $resources = NULL)
    {
        if(!isset($rules)) {
            return $this;
        }
        $startData = $resources ?: $this->getResources();
        foreach ($rules as $rule) {
            $class = $this->getRuleClass($rule, $startData);
            if($class->validateField()) {
                if($class->validateRule()) {
                    try {
                        $class->execute();
                    } catch (\Exception $ex) {
                        var_dump($exc->getFile(), $exc->getLine());
                        var_dump($exc->getMessage());
                        exit;
                    }
                    $this->executeRules($rule->rules, $class->getResultData());
                }
            }
        }
        return $this;
    }
    protected function factoryClassRule($rule)
    {
        $class = "\\mgCRM2\\Models\\AutomationRules\\" . $rule . "Rule";
        return new $class();
    }
    protected function getRuleClass($rule, $startData = [])
    {
        $class = $this->factoryClassRule(ucfirst($rule->rule));
        $class->setRule($rule)->setResultData($startData);
        return $class;
    }
    public static function getResources($inIds = NULL)
    {
        $resources = \mgCRM2\Models\Resource::withTrashed()->with(["admin", "status", "ticket", "client", "campaigns", "labels", "fieldDatasWithAll", "logs"]);
        if($inIds && is_array($inIds)) {
            $resources = $resources->whereIn($inIds);
        }
        return $resources->get();
    }
}

?>