<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services\IMAPMailer;

class MailboxWrapper
{
    protected $mailbox;
    public function __construct($mailbox)
    {
        $this->mailbox = $mailbox;
    }
    public function getId()
    {
        return $this->mailbox->id;
    }
    public function getImapMailboxStirng()
    {
        return "{" . $this->getHostName() . ":" . $this->getPort() . $this->getMethod() . $this->getOption() . "}" . $this->getFolderMailbox();
    }
    public function getMailboxName()
    {
        return $this->mailbox->name;
    }
    public function getHostName()
    {
        return $this->mailbox->receive_server;
    }
    public function getPort()
    {
        return (int) $this->mailbox->receive_port;
    }
    public function getUserName()
    {
        return $this->mailbox->SMTPUsername;
    }
    public function getPassword()
    {
        return base64_decode($this->mailbox->SMTPPassword);
    }
    public function getMethod()
    {
        return "/" . $this->mailbox->receive_method;
    }
    public function getOption()
    {
        $options = "";
        if($this->mailbox->receive_ssl) {
            foreach ($this->mailbox->receive_ssl as $option) {
                $options .= "/" . $option;
            }
        }
        return $options;
    }
    public function getFolderMailbox()
    {
        return $this->mailbox->receive_folder;
    }
}

?>