<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

/**
 * docs will be later
 *
 * @author Piotr Sarzyński <piotr.sa@modulesgarden.com> 
 */
class Mailer
{
    /**
     * Keep single instance of translation object
     * We do not want to create many many translators object's
     *
     * @var Lang instance
     */
    private static $instance;
    /**
     * base possibility
     *
     * @var array
     */
    private static $config;
    private function __construct()
    {
        self::$instance = $this;
        self::getConfig();
    }
    private function __clone()
    {
    }
    public static function getInstance()
    {
        if(self::$instance) {
            $class = get_called_class();
            self::$instance = new $class();
            self::getConfig();
        }
        return self::$instance;
    }
    public static function getValidEncodings()
    {
        return ["8bit", "7bit", "binary", "base64", "quoted-printable"];
    }
    protected static function getConfig($isConfigGlobal = true, $mailBoxId = NULL)
    {
        if($isConfigGlobal) {
            self::$config = new \stdClass();
        } else {
            if($mailBoxId == NULL) {
                return false;
            }
            self::$config = \Illuminate\Database\Capsule\Manager::table("crm_mail_configuration")->where("crm_mail_configuration.id", "=", $mailBoxId)->first();
        }
        return true;
    }
    public function getMailerObject()
    {
        global $CONFIG;
        global $mysql_charset;
        if(!$CONFIG) {
            require_once ROOTDIR . DS . "init.php";
        }
        $mailCharset = !empty($mysql_charset) ? $mysql_charset : $CONFIG["Charset"];
        $mail = mgCRM2_isWHMCS78() ? new \PHPMailer\PHPMailer\PHPMailer(true) : new \PHPMailer(true);
        $mail->SMTPDebug = false;
        if(!isset(self::$config->id)) {
            $mail->From = !empty($CONFIG["Email"]) ? $CONFIG["Email"] : $CONFIG["SystemEmailsFromEmail"];
            $mail->FromName = $CONFIG["CompanyName"];
            $mail->CharSet = $mailCharset;
            if(!empty($CONFIG["MailConfig"])) {
                $whmcsConfig = json_decode(decrypt($CONFIG["MailConfig"]));
                if($whmcsConfig->module == "PhpMail") {
                    $mail->Mailer = "mail";
                    return $mail;
                }
                $mailConfig = $whmcsConfig->configuration;
                $mail->IsSMTP();
                $mail->Host = $mailConfig->host;
                $mail->Port = $mailConfig->port;
                $mail->Hostname = $_SERVER["SERVER_NAME"];
                if(!empty($mailConfig->secure) && strtolower($mailConfig->secure) != "none") {
                    $mail->SMTPSecure = $mailConfig->secure;
                } else {
                    $mail->SMTPAutoTLS = false;
                }
                if(!empty($mailConfig->username)) {
                    $mail->SMTPAuth = true;
                    $mail->Username = $mailConfig->username;
                    $mail->Password = $mailConfig->password;
                }
                if($mailConfig->encoding) {
                    $encodings = self::getValidEncodings();
                    $key = $mailConfig->encoding;
                    if(!empty($encodings[$key])) {
                        $mail->Encoding = $encodings[$key];
                    }
                }
            } else {
                if($CONFIG["MailType"] == "mail") {
                    $mail->Mailer = "mail";
                    return $mail;
                }
                $mail->IsSMTP();
                $mail->Host = $CONFIG["SMTPHost"];
                $mail->Port = $CONFIG["SMTPPort"];
                $mail->Hostname = $_SERVER["SERVER_NAME"];
                if($CONFIG["SMTPSSL"]) {
                    $mail->SMTPSecure = $CONFIG["SMTPSSL"];
                } else {
                    $mail->SMTPAutoTLS = false;
                }
                if($CONFIG["SMTPUsername"]) {
                    $mail->SMTPAuth = true;
                    $mail->Username = $CONFIG["SMTPUsername"];
                    $mail->Password = decrypt($CONFIG["SMTPPassword"]);
                }
                if(!empty($CONFIG["MailEncoding"]) && $CONFIG["MailEncoding"] != 0) {
                    $encodings = self::getValidEncodings();
                    $key = (int) $CONFIG["MailEncoding"];
                    if(isset($encodings[$key]) && !empty($encodings[$key])) {
                        $mail->Encoding = $encodings[$key];
                    }
                }
            }
        } else {
            $mail->From = self::$config->email;
            $mail->FromName = self::$config->name;
            $mail->CharSet = $mailCharset;
            $mail->IsSMTP();
            $mail->Host = self::$config->SMTPHost;
            $mail->Port = self::$config->SMTPPort;
            $mail->Hostname = $_SERVER["SERVER_NAME"];
            if(self::$config->SMTPSSL) {
                $mail->SMTPSecure = self::$config->SMTPSSL;
            } else {
                $mail->SMTPAutoTLS = false;
            }
            if(self::$config->SMTPUsername) {
                $mail->SMTPAuth = true;
                $mail->Username = self::$config->SMTPUsername;
                $mail->Password = base64_decode(self::$config->SMTPPassword);
            }
            if(!empty($CONFIG["MailEncoding"]) && $CONFIG["MailEncoding"] != 0) {
                $encodings = self::getValidEncodings();
                $key = intval($CONFIG["MailEncoding"]);
                if(isset($encodings[$key]) && !empty($encodings[$key])) {
                    $mail->Encoding = $encodings[$key];
                }
            }
        }
        return $mail;
    }
    public static function getGlobalEmailVariables()
    {
        global $CONFIG;
        if(!$CONFIG) {
            require_once ROOTDIR . DS . "init.php";
        }
        global $customadminpath;
        $fieldsRepo = new \mgCRM2\Repositories\Fields();
        $fields = $fieldsRepo->all();
        $fieldsArray = [];
        foreach ($fields as $field) {
            $fieldsArray[$field->id] = $field->toArray();
        }
        $vars = [];
        $vars["fields"] = $fieldsArray;
        $vars["company_name"] = $CONFIG["CompanyName"];
        $vars["company_domain"] = $CONFIG["Domain"];
        if(preg_match("/^\\/\\//", $CONFIG["LogoURL"])) {
            $parsed = parse_url($CONFIG["SystemURL"]);
            $vars["company_logo_url"] = preg_replace("/^\\/\\//", $parsed["scheme"] . "://", $CONFIG["LogoURL"]);
        } else {
            $vars["company_logo_url"] = $CONFIG["LogoURL"];
        }
        $vars["whmcs_url"] = $CONFIG["SystemURL"];
        $vars["whmcs_link"] = "<a href='" . $CONFIG["SystemURL"] . "'>" . $CONFIG["SystemURL"] . "</a>";
        $vars["whmcs_admin_url"] = $CONFIG["SystemURL"] . "/" . $customadminpath;
        $vars["whmcs_admin_link"] = "<a href='" . $CONFIG["SystemURL"] . "/" . $customadminpath . "'>" . $CONFIG["SystemURL"] . "/" . $customadminpath . "</a>";
        $vars["signature"] = nl2br($CONFIG["Signature"]);
        $vars["date"] = date("Y-m-d");
        $vars["time"] = date("Y-m-d H:i:s");
        return $vars;
    }
    public static function makeSmartyObject()
    {
        global $templates_compiledir;
        if(!$templates_compiledir) {
            $templates_compiledir = ROOTDIR . DS . "templates_c" . DS;
        }
        $smarty = new \Smarty();
        $smarty->template_dir = ROOTDIR . DS . "templates" . DS;
        $smarty->caching = false;
        $smarty->error_reporting = 0;
        if(self::isItWindows()) {
            if(!strpos($templates_compiledir, ":\\") && !strpos($templates_compiledir, ":/") && !starts_with($templates_compiledir, "\\")) {
                $smarty->compile_dir = ROOTDIR . DS . $templates_compiledir;
            } else {
                $smarty->compile_dir = $templates_compiledir;
            }
        } else {
            if(substr($templates_compiledir, strlen($templates_compiledir) - 1, 1) == "/") {
                $templates_compiledir = substr($templates_compiledir, 0, -1);
            }
            if(substr($templates_compiledir, 0, 1) == "/") {
                $smarty->compile_dir = $templates_compiledir;
            } else {
                $smarty->compile_dir = ROOTDIR . DS . $templates_compiledir;
            }
        }
        return $smarty;
    }
    public static function isItWindows()
    {
        if(in_array(PHP_OS, ["WINNT", "Windows", "WIN", "WIN32"])) {
            return true;
        }
        return false;
    }
    public function sentEmailFromTemplate($emailTemplate, array $recipients = [], array $replyTo = [], array $cc = [], array $smartyVariables = [], $addtional = [])
    {
        if(empty($recipients)) {
            throw new \Exception("Cant sent email without recipment");
        }
        $customSubject = array_get($addtional, "custom_subject", NULL);
        $customContent = array_get($addtional, "custom_content", NULL);
        $bcc = array_get($addtional, "bcc", []);
        $template = \mgCRM2\Models\Whmcs\EmailTemplates::findOrFail($emailTemplate);
        $smartyVariables = array_merge($smartyVariables, self::getGlobalEmailVariables());
        $smarty = self::makeSmartyObject();
        $smarty->assign($smartyVariables);
        $mailSubject = $customSubject ?: $template->subject;
        $mailContent = $customContent ?: $template->message;
        $subject = self::smartyStringFetch($smarty, $mailSubject);
        $message = self::smartyStringFetch($smarty, $mailContent);
        global $CONFIG;
        $globalHeader = self::smartyStringFetch($smarty, html_entity_decode($CONFIG["EmailGlobalHeader"]));
        $globalFooter = self::smartyStringFetch($smarty, html_entity_decode($CONFIG["EmailGlobalFooter"]));
        $message = html_entity_decode($globalHeader . $message . "<br/>" . $globalFooter);
        $message_text = str_replace("<p>", "", $message);
        $message_text = str_replace("</p>", "\r\n\r\n", $message_text);
        $message_text = str_replace("<br>", "\r\n", $message_text);
        $message_text = str_replace("<br />", "\r\n", $message_text);
        $message_text = strip_tags($message_text);
        if(!empty($CONFIG["EmailCSS"])) {
            $globalCSS = html_entity_decode($CONFIG["EmailCSS"]);
            if(strpos($message, "[EmailCSS]") !== false) {
                $message = str_replace("[EmailCSS]", $globalCSS, $message);
            } else {
                $message = "<style type=\"text/css\">" . PHP_EOL . $globalCSS . PHP_EOL . "</style>" . PHP_EOL . $message;
            }
        }
        $mailer = self::getMailerObject();
        $mailer->Subject = $subject;
        $mailer->Body = $message;
        $mailer->AltBody = $message_text;
        foreach ($recipients as $recipment) {
            $mailer->AddAddress($recipment);
        }
        if(!empty($template->fromname)) {
            $mailer->FromName = $template->fromname;
        }
        $fromCustom = array_get($addtional, "from_email", NULL);
        if(!empty($fromCustom) && \mgCRM2\Models\Validators\Common::isValidEmail($fromCustom)) {
            $mailer->From = $fromCustom;
        } elseif(!empty($template->fromemail) && \mgCRM2\Models\Validators\Common::isValidEmail($template->fromemail)) {
            $mailer->From = $template->fromemail;
        }
        if(!empty($replyTo) && \mgCRM2\Models\Validators\Common::isValidEmail(array_get($replyTo, "email", NULL))) {
            if(array_get($replyTo, "name", NULL) != NULL) {
                $mailer->AddReplyTo(array_get($replyTo, "email"), array_get($replyTo, "name"));
            } else {
                $mailer->AddReplyTo(array_get($replyTo, "email"));
            }
        }
        $copyto = [];
        if($template->copyto) {
            $copytoarray = explode(",", $template->copyto);
            if(is_array($copytoarray)) {
                $copytoarray = array_filter($copytoarray, function ($var) {
                    return $var != "";
                });
                foreach ($copytoarray as $c) {
                    $mailer->AddCC(trim($c));
                    $copyto[] = trim($c);
                }
            }
        }
        if(!empty($cc)) {
            foreach ($cc as $c) {
                if(\mgCRM2\Models\Validators\Common::isValidEmail(array_get($c, "email", NULL))) {
                    $copyto[] = trim(array_get($c, "email", NULL));
                    if(array_get($c, "name", NULL) != NULL) {
                        $mailer->addCC(trim(array_get($c, "email", NULL)), array_get($c, "name"));
                    } else {
                        $mailer->addCC(trim(array_get($c, "email", NULL)));
                    }
                }
            }
        }
        $blinkCopyTo = [];
        if($template->blind_copy_to) {
            $blinkCopyToArray = explode(",", $template->blind_copy_to);
            if(is_array($blinkCopyToArray)) {
                $blinkCopyToArray = array_filter($blinkCopyToArray, function ($var) {
                    return $var != "";
                });
                foreach ($blinkCopyToArray as $c) {
                    $mailer->AddBCC(trim($c));
                    $blinkCopyTo[] = trim($c);
                }
            }
        }
        if(!empty($bcc)) {
            foreach ($bcc as $bc) {
                if(\mgCRM2\Models\Validators\Common::isValidEmail(array_get($bc, "email", NULL))) {
                    $blinkCopyTo[] = trim(array_get($bc, "email", NULL));
                    if(array_get($bc, "name", NULL) != NULL) {
                        $mailer->addBCC(trim(array_get($bc, "email", NULL)), array_get($bc, "name"));
                    } else {
                        $mailer->addBCC(trim(array_get($bc, "email", NULL)));
                    }
                }
            }
        }
        $templateAttachments = explode(",", $template->attachments);
        $attachments = [];
        if(!empty($templateAttachments) && is_array($templateAttachments)) {
            $model = (new \mgCRM2\Models\Whmcs\FileAssetSetting())->byType(\mgCRM2\Models\Whmcs\FileAssetSetting::TYPE_EMAIL_TEMPLATE_ATTACHMENTS)->first();
            $settings = json_decode($model->configuration->settings);
            $attachmentsDir = $settings->local_path . DS;
            foreach ($templateAttachments as $file) {
                if(file_exists($attachmentsDir . $file) && !empty($file)) {
                    $mailer->AddAttachment($attachmentsDir . $file, $file);
                    $attachments[] = $file;
                }
            }
        }
        $sender = "";
        if(isset($addtional["from_email"])) {
            $sender = $addtional["from_email"];
        }
        if(isset($replyTo["email"])) {
            $sender = $replyTo["email"];
        }
        if($mailer->Send()) {
            if($addtional["resource_id"] || $addtional["followup_id"] || $addtional["reminder_id"] || 0 < count($recipients)) {
                $emailLog = new \mgCRM2\Models\EmailLog(["resource_id" => $addtional["resource_id"], "followup_id" => $addtional["followup_id"], "reminder_id" => $addtional["reminder_id"], "date" => \Carbon\Carbon::now(), "subject" => $subject, "message" => $message, "sender" => $sender, "to" => implode(",", $recipients), "cc" => implode(",", $copyto), "bcc" => implode(",", $blinkCopyTo), "attachments" => implode(",", $attachments), "template_id" => (int) $emailTemplate]);
                $emailLog->save();
            }
            return true;
        }
        return false;
    }
    public function sentRawEmail(array $recipients = [], array $replyTo = [], array $cc = [], $from = NULL, $subjectRaw = NULL, $contentRaw = NULL, array $files = [], array $smartyVariables = [], $addtional = [])
    {
        if(empty($recipients)) {
            throw new \Exception("Cant sent emtil without recipment");
        }
        if(!isset(self::$config->id)) {
            self::getConfig(!array_get($addtional, "mailbox_id", false), array_get($addtional, "mailbox_id", NULL));
        }
        $smartyVariables = array_merge($smartyVariables, self::getGlobalEmailVariables());
        $smarty = self::makeSmartyObject();
        $smarty->assign($smartyVariables);
        $subject = self::smartyStringFetch($smarty, $subjectRaw);
        $message = self::smartyStringFetch($smarty, $contentRaw);
        $copyto = [];
        $blinkCopyTo = [];
        $cc = array_get($addtional, "cc", []);
        $bcc = array_get($addtional, "bcc", []);
        global $CONFIG;
        $globalHeader = self::smartyStringFetch($smarty, html_entity_decode($CONFIG["EmailGlobalHeader"]));
        $globalFooter = self::smartyStringFetch($smarty, html_entity_decode($CONFIG["EmailGlobalFooter"]));
        $message = html_entity_decode($globalHeader . $message . "<br/>" . $globalFooter);
        $message_text = str_replace("<p>", "", $message);
        $message_text = str_replace("</p>", "\r\n\r\n", $message_text);
        $message_text = str_replace("<br>", "\r\n", $message_text);
        $message_text = str_replace("<br />", "\r\n", $message_text);
        $message_text = strip_tags($message_text);
        if(!empty($CONFIG["EmailCSS"])) {
            $globalCSS = html_entity_decode($CONFIG["EmailCSS"]);
            if(strpos($message, "[EmailCSS]") !== false) {
                $message = str_replace("[EmailCSS]", $globalCSS, $message);
            } else {
                $message = "<style type=\"text/css\">" . PHP_EOL . $globalCSS . PHP_EOL . "</style>" . PHP_EOL . $message;
            }
        }
        $mailer = self::getMailerObject();
        $mailer->Subject = $subject;
        $mailer->Body = $message;
        $mailer->AltBody = $message_text;
        foreach ($recipients as $recipment) {
            $mailer->AddAddress($recipment);
        }
        if(!empty($from) && is_array($from) && \mgCRM2\Models\Validators\Common::isValidEmail(array_get($from, "email", NULL))) {
            if(array_get($from, "name", NULL) != NULL) {
                $mailer->FromName = array_get($from, "name", NULL);
            }
            $mailer->From = array_get($from, "email", NULL);
        } elseif(!empty($from) && \mgCRM2\Models\Validators\Common::isValidEmail($from)) {
            $mailer->From = $from;
        }
        if(!empty($replyTo) && \mgCRM2\Models\Validators\Common::isValidEmail(array_get($replyTo, "email", NULL))) {
            if(array_get($replyTo, "name", NULL) != NULL) {
                $mailer->AddReplyTo(array_get($replyTo, "email"), array_get($replyTo, "name"));
            } else {
                $mailer->AddReplyTo(array_get($replyTo, "email"));
            }
        }
        if(!empty($cc)) {
            foreach ($cc as $c) {
                if(\mgCRM2\Models\Validators\Common::isValidEmail(array_get($c, "email", NULL))) {
                    $copyto[] = trim(array_get($c, "email", NULL));
                    if(array_get($c, "name", NULL) != NULL) {
                        $mailer->addCC(trim(array_get($c, "email", NULL)), array_get($c, "name"));
                    } else {
                        $mailer->addCC(trim(array_get($c, "email", NULL)));
                    }
                }
            }
        }
        if(!empty($bcc)) {
            foreach ($bcc as $bc) {
                if(\mgCRM2\Models\Validators\Common::isValidEmail(array_get($bc, "email", NULL))) {
                    $blinkCopyTo[] = trim(array_get($bc, "email", NULL));
                    if(array_get($bc, "name", NULL) != NULL) {
                        $mailer->addBCC(trim(array_get($bc, "email", NULL)), array_get($bc, "name"));
                    } else {
                        $mailer->addBCC(trim(array_get($bc, "email", NULL)));
                    }
                }
            }
        }
        $attachments = [];
        if(!empty($files) && is_array($files)) {
            foreach ($files as $file) {
                if(file_exists(array_get($file, "tmp_name")) && array_get($file, "name", NULL) != NULL) {
                    $mailer->AddAttachment($file["tmp_name"], $file["name"]);
                    $attachments[] = $file["name"];
                }
            }
        }
        if($addtional["mailbox_id"]) {
            $mailbox = \mgCRM2\Models\Mailbox::where("id", $addtional["mailbox_id"])->get();
            $from = $mailbox->toArray()[0]["email"];
        }
        if($mailer->Send()) {
            if($addtional["resource_id"] || $addtional["followup_id"] || $addtional["reminder_id"] || 0 < count($recipients)) {
                $emailLog = new \mgCRM2\Models\EmailLog(["resource_id" => array_get($addtional, "resource_id", NULL), "followup_id" => array_get($addtional, "followup_id", NULL), "reminder_id" => array_get($addtional, "reminder_id", NULL), "date" => \Carbon\Carbon::now(), "sender" => $from, "subject" => $subject, "message" => $message, "to" => implode(",", $recipients), "cc" => implode(",", $copyto), "bcc" => implode(",", $blinkCopyTo), "attachments" => implode(",", $attachments)]);
                $emailLog->save();
            }
            if($addtional["client_id"]) {
                \mgCRM2\Models\Whmcs\ClientEmailLog::insertLog(["userid" => array_get($addtional, "client_id", NULL), "subject" => $subject, "message" => $message, "to" => implode(",", $recipients), "cc" => implode(",", $copyto), "bcc" => implode(",", $blinkCopyTo)]);
            }
            return true;
        }
        return false;
    }
    public function sentReminderEmailFromTemplate($emailTemplate, array $recipients = [], array $replyTo = [], array $cc = [], array $smartyVariables = [], $additional = [])
    {
        $parsed = ["resource_id" => array_get($additional, "resource_id", NULL), "followup_id" => array_get($additional, "followup_id", NULL), "reminder_id" => array_get($additional, "reminder_id", NULL), "bcc" => array_get($additional, "bcc", NULL)];
        self::getConfig(array_get($additional, "is_global_config", true), array_get($additional, "department_id", NULL));
        return $this->sentEmailFromTemplate($emailTemplate, $recipients, $replyTo, $cc, $smartyVariables, $parsed);
    }
    public function sentEmailFromRawData($from, $to, $subject, $content, array $files = [], $smartyVariables = [], $addtional = [])
    {
        $parsed = ["resource_id" => array_get($addtional, "resource_id", NULL), "followup_id" => array_get($addtional, "followup_id", NULL), "reminder_id" => array_get($addtional, "reminder_id", NULL), "cc" => array_get($addtional, "cc", NULL), "bcc" => array_get($addtional, "bcc", NULL)];
        $parsedFiles = [];
        $tmpFiles = array_get($files, "files", []);
        if(!empty($tmpFiles)) {
            foreach ($tmpFiles["error"] as $key => $error) {
                if($error == UPLOAD_ERR_OK) {
                    $parsedFiles[] = ["name" => array_get($tmpFiles, "name." . $key, NULL), "tmp_name" => array_get($tmpFiles, "tmp_name." . $key, NULL)];
                }
            }
        }
        self::getConfig(array_get($addtional, "is_global_config", true), array_get($addtional, "department_id", NULL));
        return $this->sentRawEmail([$to], [], [], $from, $subject, $content, $parsedFiles, $smartyVariables, $parsed);
    }
    public function sentRawEmailFromTemplate($from, $to, $template, $smartyVariables, $addtional = [])
    {
        $parsed = ["resource_id" => array_get($addtional, "resource_id", NULL), "followup_id" => array_get($addtional, "followup_id", NULL), "reminder_id" => array_get($addtional, "reminder_id", NULL), "from_email" => $from, "custom_subject" => array_get($addtional, "subject", NULL), "custom_content" => array_get($addtional, "content", NULL), "bcc" => array_get($addtional, "bcc", NULL)];
        $cc = array_get($addtional, "cc", []);
        self::getConfig(array_get($addtional, "is_global_config", true), array_get($addtional, "department_id", NULL));
        return $this->sentEmailFromTemplate($template, [$to], [], $cc, $smartyVariables, $parsed);
    }
    public static function registerResources($smarty)
    {
        $smarty->register_resource("fromstr", [[get_called_class(), "fromstr_template"], [get_called_class(), "fromstr_timestamp"], [get_called_class(), "fromstr_secure"], [get_called_class(), "fromstr_trusted"]]);
    }
    public static function fromstr_template($tpl_name, &$tpl_source, &$smarty_obj)
    {
        $tpl_source = $smarty_obj->get_template_vars($tpl_name);
        return empty($tpl_source) ? false : true;
    }
    public static function fromstr_timestamp($tpl_name, &$tpl_timestamp, &$smarty_obj)
    {
        $tpl_timestamp = time();
        return true;
    }
    public static function fromstr_secure($tpl_name, &$smarty_obj)
    {
        return true;
    }
    public static function fromstr_trusted($tpl_name, &$smarty_obj)
    {
    }
    public static function smartyStringFetch(&$smarty, $content)
    {
        $smarty->compile_id = md5($content . time());
        try {
            if(defined("Smarty::SMARTY_VERSION")) {
                $ver = str_replace("Smarty-", "", $smarty::SMARTY_VERSION);
                $versioncheck = version_compare("3.0.0", $ver, "<");
            } else {
                $versioncheck = false;
            }
        } catch (\Exception $ex) {
            $versioncheck = false;
        }
        if($versioncheck) {
            $result = $smarty->fetch("string:" . $content);
        } else {
            self::registerResources($smarty);
            $uid = uniqid();
            $smarty->assign($uid, $content);
            $result = $smarty->fetch("fromstr:" . $uid);
            $smarty->unregister_resource("fromstr");
        }
        return $result;
    }
}

?>