<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

/**
 * Class MailerReceive
 * @package mgCRM2\Services
 * @property MailboxBody $mailboxBody
 */
class MailerReceive
{
    /**
     * @var Mailbox
     */
    protected $mailbox;
    protected $imap;
    protected $imapHeader;
    protected $readNewMail = 0;
    protected $createdNewNotification = 0;
    protected $errorMessage;
    protected $mailcharset;
    protected $globalConfig;
    protected $disableIconv;
    protected $mailboxBody;
    /**
     * @var Resource[]
     */
    protected $resourceList;
    public function __construct($idMailbox = NULL)
    {
        if(!function_exists("imap_open")) {
            throw new \Exception("IMAP needs to be compiled into PHP for this to function.");
        }
        global $CONFIG;
        global $disable_iconv;
        $this->globalConfig = $CONFIG;
        $this->disableIconv = $disable_iconv;
        $this->resourceList = \mgCRM2\Models\Resource::with("client")->get();
        $this->mailboxBody = new \mgCRM2\Models\MailboxResources\MailboxBody();
        if(!is_null($idMailbox)) {
            $this->loadMailBox($idMailbox);
        }
    }
    protected function searchResource($email)
    {
        $resourceList = [];
        foreach ($this->resourceList as $resource) {
            if($resource->email == $email || $resource->client && $resource->client->email == $email) {
                $resourceList[] = $resource;
            }
        }
        return $resourceList;
    }
    public function restart()
    {
        $this->mailbox = NULL;
        $this->imap = NULL;
        $this->imapHeader = NULL;
        $this->errorMessage = NULL;
        $this->readNewMail = 0;
        $this->createdNewNotification = 0;
        return $this;
    }
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    public function isError()
    {
        return $this->getErrorMessage() !== NULL;
    }
    public function loadMailBox($id = NULL)
    {
        if(is_null($id)) {
            throw new \Exception("Need set Mailbox.");
        }
        $this->mailbox = \mgCRM2\Models\Mailbox::where("id", $id)->first();
        return $this;
    }
    public function getNewMail()
    {
        return $this->readNewMail;
    }
    public function getNewNotifications()
    {
        return $this->createdNewNotification;
    }
    public function getMailBox()
    {
        if(empty($this->mailbox)) {
            $this->loadMailBox(\mgCRM2\Models\Mailbox::first()->id);
        }
        return $this->mailbox;
    }
    public function getHostName()
    {
        return $this->getMailBox()->receive_server;
    }
    public function getMailboxName()
    {
        return $this->getMailBox()->name;
    }
    public function getPort()
    {
        return (int) $this->getMailBox()->receive_port;
    }
    public function userName()
    {
        return $this->getMailBox()->SMTPUsername;
    }
    public function password()
    {
        return base64_decode($this->getMailBox()->SMTPPassword);
    }
    public function getMethod()
    {
        return "/" . $this->getMailBox()->receive_method;
    }
    public function getOption()
    {
        $options = "";
        if($this->getMailBox()->receive_ssl) {
            foreach ($this->getMailBox()->receive_ssl as $option) {
                $options .= "/" . $option;
            }
        }
        return $options;
    }
    public function receiveMailBox()
    {
        if(!$this->getHostName() || !$this->getPort() || !$this->userName() || !$this->password()) {
            $this->errorMessage = "Mailbox '" . $this->getMailboxName() . "' has not been configurated.";
            return $this;
        }
        try {
            $this->imapOpen();
            if(!$this->imap) {
                $this->errorMessage = imap_last_error();
            } else {
                $this->imapReadHeaders()->readMails()->imapClose();
            }
        } catch (\Exception $ex) {
            $error = imap_last_error();
            $this->errorMessage = $exc->getMessage() . " - " . $error;
        }
        return $this;
    }
    public function removeEmail($id)
    {
        if(!$this->getHostName() || !$this->getPort() || !$this->userName() || !$this->password()) {
            $this->errorMessage = "Mailbox '" . $this->getMailboxName() . "' has not been configurated.";
            return $this;
        }
        try {
            $this->imapOpen();
            if($this->imap === false) {
                $this->errorMessage = imap_last_error();
            } else {
                $mailNo = $this->getMessageNoByMessageId($id);
                if($mailNo !== false) {
                    imap_delete($this->imap, $mailNo);
                    imap_expunge($this->imap);
                    $this->imapClose();
                } else {
                    throw new \Exception("We coudln't find message you were trying to delete on server");
                }
            }
        } catch (\Exception $ex) {
            $error = imap_last_error();
            $this->errorMessage = $exc->getMessage() . " - " . $error;
        }
    }
    protected function getFoldermailbox()
    {
        return $this->getMailBox()->receive_folder;
    }
    protected function getImapMailboxStirng()
    {
        return "{" . $this->getHostName() . ":" . $this->getPort() . $this->getMethod() . $this->getOption() . "}" . $this->getFoldermailbox();
    }
    protected function imapReadHeaders()
    {
        $date = date("j F Y");
        $this->imapHeader = imap_search($this->imap, "ON \"" . $date . "\"");
        return $this;
    }
    protected function readMails()
    {
        if(is_array($this->imapHeader) === false) {
            return $this;
        }
        foreach ($this->imapHeader as $mail) {
            $info = new Wrapper((object) $this->readHederInfo($mail));
            if($info->id) {
                if(!$this->isExistMailReadByMailId($info->id)) {
                    $info->message = $this->readBody($mail);
                    preg_match("/#(\\d+)\\b/", $info->subject, $match);
                    $resources = $this->searchResource($info->fromEmail);
                    $structure = imap_fetchstructure($this->imap, $mail);
                    $emailsToNotify = [];
                    $settings = \mgCRM2\Repositories\Settings::getSingleParameter("email_import_type");
                    if(!isset($settings["email_import_type"])) {
                        $settings["email_import_type"] = NULL;
                    }
                    if(0 < count($resources)) {
                        foreach ($resources as $resource) {
                            foreach ($info->to as $to) {
                                $id = $settings["email_import_type"] === 3 ? $match[1] ?? $resource->id : $resource->id;
                                if((int) $resource->id === (int) $id) {
                                    if($this->isExistMailRead($id, $to, $info->id) === false) {
                                        $this->createMailRead($info, $to, $id);
                                        $this->sendNotification($resource);
                                        $emailsToNotify[] = ["resource_id" => $id, "title" => $info->subject];
                                        $this->createdNewNotification++;
                                        if(!isset($structure->parts)) {
                                            $this->createAttachment($this->imap, $mail, new Wrapper((object) $structure), 0);
                                        } else {
                                            foreach ($structure->parts as $partno0 => $p) {
                                                if(!isset($p->disposition)) {
                                                    $p->disposition = NULL;
                                                }
                                                if($p->disposition == "attachment") {
                                                    $this->createAttachment($this->imap, $mail, new Wrapper((object) $p), $partno0 + 1);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if(!empty($emailsToNotify)) {
                            (new \mgCRM2\Repositories\Notifications())->createEmailNotifications($emailsToNotify);
                        }
                    } else {
                        foreach ($info->to as $to) {
                            if($this->isExistMailRead(0, $to, $info->id) === false) {
                                $this->createMailRead($info, $to, 0);
                                $this->sendAnonymousNotification($info->fromEmail);
                                if(!isset($structure->parts)) {
                                    $this->createAttachment($this->imap, $mail, new Wrapper((object) $structure), 0);
                                } else {
                                    foreach ($structure->parts as $partno0 => $p) {
                                        $this->createAttachment($this->imap, $mail, new Wrapper((object) $p), $partno0 + 1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return $this;
    }
    protected function isExistMailRead($resourceId, $to, $messageId)
    {
        return 0 < \mgCRM2\Models\MailboxRead::where("resource_id", $resourceId)->where("email", $to)->where("mail_id", $messageId)->count();
    }
    protected function isExistMailReadByMailId($messageId)
    {
        return 0 < \mgCRM2\Models\MailboxRead::withTrashed()->where("mail_id", $messageId)->count();
    }
    protected function createMailRead($info, $to, $resourceId)
    {
        \mgCRM2\Models\MailboxRead::create(["resource_id" => $resourceId, "mail_configuration_id" => $this->getMailBox()->id, "email" => $to, "from_email" => $info->fromEmail, "mail_id" => $info->id, "title" => $info->subject, "content" => $info->message, "date" => \Carbon\Carbon::createFromFormat("Y-m-d H:i:s", date("Y-m-d H:i:s", strtotime($info->date))), "reply_to" => $info->replyTo[0] ? $info->replyTo[0] : " "]);
        $this->readNewMail = $this->readNewMail + 1;
        return $this;
    }
    protected function imapOpen()
    {
        imap_timeout(IMAP_OPENTIMEOUT, 10);
        $this->imap = imap_open($this->getImapMailboxStirng(), $this->userName(), $this->password());
        return $this;
    }
    protected function imapClose()
    {
        imap_close($this->imap);
        return $this;
    }
    private function readBody($number)
    {
        $this->clearBodyHandler();
        $structure = new Wrapper((object) imap_fetchstructure($this->imap, $number));
        if(!isset($structure->parts)) {
            $this->getPart($this->imap, $number, new Wrapper((object) $structure), 0);
        } else {
            foreach ($structure->parts as $partno0 => $p) {
                $this->getPart($this->imap, $number, new Wrapper((object) $p), $partno0 + 1);
            }
        }
        $msgBody = !$this->mailboxBody->htmlMessage ? $this->mailboxBody->plainMsg : $this->mailboxBody->htmlMessage;
        return str_replace("&nbsp;", " ", !$msgBody ? "No message found." : $msgBody);
    }
    protected function clearBodyHandler()
    {
        $this->mailboxBody->clearAttributes();
    }
    public function getPart($mbox, $mid, $_obfuscated_61696C626F7820626F64792070617274730A20202020202A2040706172616D20246D626F780A20202020202A2040706172616D20246D69640A20202020202A2040706172616D2024700A20202020202A2040706172616D2024706172746E6F0A20202020202A2F_, $partno)
    {
        $data = $partno ? imap_fetchbody($mbox, $mid, $partno) : imap_body($mbox, $mid);
        if(!isset($p->encoding)) {
            $p->encoding = NULL;
        }
        if($p->encoding == 4) {
            $data = quoted_printable_decode($data);
        } elseif($p->encoding == 3) {
            $data = base64_decode($data);
        }
        $params = [];
        $params["charset"] = NULL;
        if(isset($p->parameters)) {
            foreach ($p->parameters as $x) {
                $params[strtolower($x->attribute)] = $x->value;
            }
        }
        if(isset($p->dparameters)) {
            foreach ($p->dparameters as $x) {
                $params[strtolower($x->attribute)] = $x->value;
            }
        }
        if(isset($params["filename"]) || isset($params["name"])) {
            $filename = $params["filename"] ? $params["filename"] : $params["name"];
            $this->mailboxBody->attachments[$filename] = $data;
        }
        $this->mailboxBody->plainmsg = "";
        $this->mailboxBody->htmlMessage = "";
        if($p->type == 0 && $data) {
            if(strtolower($p->subtype) == "plain") {
                $this->mailboxBody->plainMsg .= trim($data) . "\n\n";
            } else {
                $this->mailboxBody->htmlMessage .= $data . "<br><br>";
            }
            $this->mailboxBody->charset = $params["charset"] ?: NULL;
        } elseif($p->type == 2 && $data) {
            $this->mailboxBody->plainmsg .= $data . "\n\n";
        }
        if($p->parts) {
            foreach ($p->parts as $partno0 => $p2) {
                $this->getPart($mbox, $mid, new Wrapper((object) $p2), $partno . "." . ($partno0 + 1));
            }
        }
    }
    private function createAttachment($mbox, $mid, $p, $partno)
    {
        $data = $partno ? imap_fetchbody($mbox, $mid, $partno) : imap_body($mbox, $mid);
        if(!isset($p->dparameters)) {
            $p->dparameters = [];
            $p->dparameters[] = new \stdClass();
            $p->dparameters[0]->value = "";
        }
        $readMail = \mgCRM2\Models\MailboxRead::orderBy("id", "DESC")->first();
        $attachment = ["mailbox_id" => $this->getMailBox()->id, "mail_read_id" => $readMail->id, "filename" => $p->dparameters[0]->value, "attachment" => $data];
        \mgCRM2\Models\Attachment::create($attachment);
    }
    private function readHederInfo($number)
    {
        $info = new \stdClass();
        if($headers = @imap_headerinfo($this->imap, (int) $number)) {
            $headers = new Wrapper($headers);
            $info->id = $headers->message_id;
            if($headers->from) {
                $headersFrom = new Wrapper((object) $headers->from[0]);
                $info->fromEmail = $headersFrom->mailbox . "@" . $headersFrom->host;
                $elements = imap_mime_header_decode($headersFrom->personal ?: $headersFrom->mailbox . "@" . $headersFrom->host);
                $elements = new Wrapper((object) $elements[0]);
                $fromName = $elements->text;
                if($elements->charset && function_exists("iconv") && !$this->disableIconv && $elements->charset != "default") {
                    $fromName = iconv($elements->charset, $this->globalConfig["Charset"] ?: NULL, $fromName);
                }
                $info->fromName = str_replace(["<", ">", "\"", "'"], "", $fromName);
            }
            $info->to = [];
            if($headers->to) {
                $headersTo = $headers->to;
                foreach ($headersTo as $to) {
                    if(!strstr($to->mailbox . "@" . $to->host, "UNEXPECTED_DATA")) {
                        $info->to[] = $to->mailbox . "@" . $to->host;
                    }
                }
            }
            $info->cc = [];
            if($headers->cc) {
                $headersCc = $headers->cc;
                foreach ($headersCc as $cc) {
                    $info->cc[] = $cc->mailbox . "@" . $cc->host;
                }
            }
            $info->date = $headers->Date ? htmlspecialchars($headers->Date) : "&nbsp;";
            $info->subject = NULL;
            if($headers->subject) {
                $elements = imap_mime_header_decode($headers->subject);
                foreach ($elements as $element) {
                    if($element->charset && function_exists("iconv") && !$this->disableIconv && $element->charset != "default") {
                        $info->subject .= iconv($element->charset, $this->globalConfig["Charset"] ?: NULL, $element->text);
                    } else {
                        $info->subject .= $element->text;
                    }
                }
                $info->subject = $info->subject ? $info->subject : "No Subject";
            } else {
                $info->subject = "No Subject";
            }
            $info->replyTo = [];
            if(is_array($headers->reply_to)) {
                foreach ($headers->reply_to as $replyTo) {
                    $info->replyTo[] = $replyTo->mailbox . "@" . $replyTo->host;
                }
            }
        } else {
            $info = false;
        }
        return $info;
    }
    public function checkMineType($structure, $mineType)
    {
        $primaryMimeType = ["TEXT", "MULTIPART", "MESSAGE", "APPLICATION", "AUDIO", "IMAGE", "VIDEO", "OTHER"];
        if($structure->subtype) {
            return $primaryMimeType[(int) $structure->type] . "/" . $structure->subtype == $mineType;
        }
        return "TEXT/PLAIN" == $mineType;
    }
    private function getMessageNoByMessageId($id)
    {
        $mails = imap_search($this->imap, "ALL");
        foreach ($mails as $mail) {
            $info = imap_headerinfo($this->imap, $mail);
            if($info && $info->message_id == $id) {
                return $mail;
            }
        }
        return false;
    }
    private function sendNotification($resource = NULL)
    {
        $url = $this->generateUrl($resource->id);
        $title = Language::translate("new.email.notification.title", ["inbox" => $this->mailbox->name, "contact_name" => $resource->name]);
        $desc = Language::translate("new.email.notification.description", ["contact_name" => $resource->name, "url_to_respond" => $url]);
        WhmcsApi::getInstance()->triggerNotificationEvent($title, $desc, "info", $url);
    }
    private function sendAnonymousNotification($email = NULL)
    {
        $title = Language::translate("new.email.notification.title.anonymous", ["inbox" => $this->mailbox->name, "contact_name" => $email]);
        $desc = Language::translate("new.email.notification.description.anonymous", ["contact_name" => $email]);
        WhmcsApi::getInstance()->triggerNotificationEvent($title, $desc, "info", NULL);
    }
    private function generateUrl($id = NULL)
    {
        global $CONFIG;
        global $customadminpath;
        $path = empty($customadminpath) ? "admin" : $customadminpath;
        return $CONFIG["SystemURL"] . "/" . $path . "/crm.php#!/contacts/" . $id . "/emails";
    }
}

?>