<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

/**
 * Monitor Class
 * based on singletron
 * used to obtain various data regardless on integration with other modules
 *
 * @author Piotr Sarzyński <piotr.sa@modulesgarden.com> 
 */
class Monitor
{
    /**
     * Keep single instance of translation object
     * We do not want to create many many translators object's
     *
     * @var Lang instance
     */
    private static $instance;
    /**
     * base possibility
     *
     * @var array
     */
    private static $config;
    const COMPATIBLE_SMS_CENTER = "1.3.0";
    const COMPATIBLE_ASTERISK = "1.0.0";
    private function __construct()
    {
        self::$instance = $this;
    }
    private function __clone()
    {
    }
    public static function getInstance()
    {
        if(self::$instance) {
            $class = get_called_class();
            self::$instance = new $class();
        }
        return self::$instance;
    }
    public function checkIntegrations()
    {
        foreach (self::$config["integrations"] as $what => $is) {
            self::checkIntegration($what);
        }
        return self::$config["integrations"];
    }
    public function checkIntegration($what)
    {
        if(!array_key_exists($what, self::$config["integrations"])) {
            return false;
        }
        if($what == "asterisk") {
            $asterisk = \Illuminate\Database\Capsule\Manager::table("tbladdonmodules")->where("module", "=", "asteriskVoipCenter")->where("setting", "=", "version")->select("value")->first();
            if(version_compare(array_get((array) $asterisk, "value", NULL), self::COMPATIBLE_ASTERISK, ">=")) {
                array_set(self::$config, "integrations.asterisk", true);
            } else {
                array_set(self::$config, "integrations.asterisk", false);
            }
        } elseif($what == "sms_center") {
            $smsCenter = \Illuminate\Database\Capsule\Manager::table("tbladdonmodules")->where("module", "=", "sms_center")->where("setting", "=", "version")->select("value")->first();
            if(version_compare(array_get((array) $smsCenter, "value", NULL), self::COMPATIBLE_SMS_CENTER, ">=")) {
                array_set(self::$config, "integrations.sms_center", true);
            } else {
                array_set(self::$config, "integrations.sms_center", false);
            }
        } elseif($what == "quotes_automation") {
            array_set(self::$config, "integrations.quotes_automation", false);
        }
        return array_get(self::$config, "integrations." . $what, false);
    }
    public function getEmailTemplatesNum()
    {
        if(array_get(self::$config, "emails.count", NULL) !== NULL) {
            return 0;
        }
        $count = \Illuminate\Database\Capsule\Manager::table("tblemailtemplates")->where("type", "=", "crm")->count();
        array_set(self::$config, "emails.count", $count);
        return $count;
    }
    public function checkCronStatus()
    {
        $previousRun = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "mgCRM2_cron_previous")->select("value")->first();
        $lastRun = \Illuminate\Database\Capsule\Manager::table("tblconfiguration")->where("setting", "=", "mgCRM2_cron_last")->select("value")->first();
        $lastRunTimestamp = array_get((array) $lastRun, "value", false);
        $previousRunTimestamp = array_get((array) $previousRun, "value", false);
        $last = false;
        $dateDiff = false;
        if($lastRunTimestamp) {
            $last = \Carbon\Carbon::createFromTimestamp($lastRunTimestamp);
            $now = \Carbon\Carbon::now();
            array_set(self::$config, "cron.last_run", $last->toDateTimeString());
            array_set(self::$config, "cron.interval", $now->diffInMinutes($last));
        } else {
            array_set(self::$config, "cron.interval", false);
        }
        array_set(self::$config, "cron.path", \mgCRM2\Integration\Slim\SlimApp::getInstance()->config("appInternalModuleDir") . "cron.php");
        array_set(self::$config, "cron.url", \mgCRM2\Integration\Slim\SlimApp::getInstance()->whmcs->getSystemUrl() . "modules/addons/mgCRM2/cron.php");
        return self::$config["cron"];
    }
}

?>