<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

if(!class_exists("\\Smarty")) {
    require_once ROOTDIR . "/init.php";
    require_once ROOTDIR . "/includes/adminfunctions.php";
}
/**
 * Use with SMS Center module cooperation
 *
 * @author Piotr Sarzyński <piotr.sa@modulesgarden.com> 
 */
class SenderSms
{
    private static $adminName;
    /**
     * Keep single instance of translation object
     * We do not want to create many many translators object's
     *
     * @var Lang instance
     */
    private static $instance;
    private function __construct()
    {
    }
    private function __clone()
    {
    }
    public static function getInstance()
    {
        if(NULL === static::$instance) {
            static::$instance = new static();
            static::$adminName = \mgCRM2\Integration\Slim\SlimApp::getInstance()->whmcs->getAdminNameForAPIcall();
        }
        return static::$instance;
    }
    public static function getGlobalEmailVariables()
    {
        global $CONFIG;
        global $customadminpath;
        $vars = [];
        $vars["company_name"] = $CONFIG["CompanyName"];
        $vars["company_domain"] = $CONFIG["Domain"];
        $vars["company_logo_url"] = $CONFIG["LogoURL"];
        $vars["whmcs_url"] = $CONFIG["SystemURL"];
        $vars["whmcs_link"] = "<a href='" . $CONFIG["SystemURL"] . "'>" . $CONFIG["SystemURL"] . "</a>";
        $vars["whmcs_admin_url"] = $CONFIG["SystemURL"] . $customadminpath;
        $vars["whmcs_admin_link"] = "<a href='" . $CONFIG["SystemURL"] . "/" . $customadminpath . "'>" . $CONFIG["SystemURL"] . "/" . $customadminpath . "</a>";
        $vars["signature"] = $CONFIG["Signature"];
        $vars["date"] = date("Y-m-d");
        $vars["time"] = date("Y-m-d H:i:s");
        return $vars;
    }
    public static function makeSmartyObject()
    {
        global $templates_compiledir;
        if(!$templates_compiledir) {
            $templates_compiledir = ROOTDIR . DS . "templates_c" . DS;
        }
        $smarty = new \Smarty();
        $smarty->template_dir = ROOTDIR . DS . "templates" . DS;
        $smarty->caching = false;
        $smarty->error_reporting = 0;
        if(substr($templates_compiledir, strlen($templates_compiledir) - 1, 1) == "/") {
            $templates_compiledir = substr($templates_compiledir, 0, -1);
        }
        if(substr($templates_compiledir, 0, 1) == "/") {
            $smarty->compile_dir = $templates_compiledir;
        } else {
            $smarty->compile_dir = ROOTDIR . DS . $templates_compiledir;
        }
        return $smarty;
    }
    public function sentRawSMSForClient($targetClientID = NULL, $targetPhone = NULL, $contentRaw = NULL, array $smartyVariables = [], $addtional = [])
    {
        $smartyVariables = array_merge($smartyVariables, self::getGlobalEmailVariables());
        $smarty = self::makeSmartyObject();
        $smarty->assign($smartyVariables);
        $message = trim(self::smartyStringFetch($smarty, $contentRaw));
        $params = ["message" => $message, "force" => 1];
        if(\mgCRM2\Models\Validators\Common::isPositiveUnsignedNumber($targetClientID)) {
            $params["userid"] = $targetClientID;
        } elseif(!empty($targetPhone)) {
            $params["phonenumber"] = $targetPhone;
        } else {
            throw new \Exception("Not enough parameters to send query to SMS Center");
        }
        $result = localAPI("sendsms", $params, static::$adminName);
        if($result["result"] != "error") {
            if($addtional["resource_id"] || $addtional["followup_id"] || $addtional["reminder_id"]) {
                $emailLog = new \mgCRM2\Models\EmailLog(["resource_id" => $addtional["resource_id"], "followup_id" => $addtional["followup_id"], "reminder_id" => $addtional["reminder_id"], "date" => \Carbon\Carbon::now(), "subject" => "SMS", "message" => $message, "to" => $targetPhone ? $targetPhone : "", "cc" => ""]);
                $emailLog->save();
            }
            if($addtional["client_id"]) {
                \mgCRM2\Models\Whmcs\ClientEmailLog::insertLog(["userid" => $addtional["client_id"], "subject" => "SMS", "message" => $message, "to" => $targetPhone ? $targetPhone : "", "cc" => "", "bcc" => ""]);
            }
        }
        return $result;
    }
    public function sentReminderSMSFromTemplate($targetAdminID, $templateID, array $smartyVariables = [], $addtional = [])
    {
        $smartyVariables = array_merge($smartyVariables, self::getGlobalEmailVariables());
        $smarty = self::makeSmartyObject();
        $smarty->assign($smartyVariables);
        $template = \Illuminate\Database\Capsule\Manager::table("tblemailtemplates")->where("id", "=", $templateID)->first();
        $message = trim(self::smartyStringFetch($smarty, $template->message));
        $params = ["message" => $message, "body" => $message, "admin" => $targetAdminID, "force" => 1];
        $result = localAPI("sendsms", $params, static::$adminName);
        if($result["result"] == "success") {
            return true;
        }
        return false;
    }
    public static function registerResources(&$smarty)
    {
        $smarty->register_resource("fromstr", [[get_called_class(), "fromstr_template"], [get_called_class(), "fromstr_timestamp"], [get_called_class(), "fromstr_secure"], [get_called_class(), "fromstr_trusted"]]);
    }
    public static function fromstr_template($tpl_name, &$tpl_source, &$smarty_obj)
    {
        $tpl_source = $smarty_obj->get_template_vars($tpl_name);
        return empty($tpl_source) ? false : true;
    }
    public static function fromstr_timestamp($tpl_name, &$tpl_timestamp, &$smarty_obj)
    {
        $tpl_timestamp = time();
        return true;
    }
    public static function fromstr_secure($tpl_name, &$smarty_obj)
    {
        return true;
    }
    public static function fromstr_trusted($tpl_name, &$smarty_obj)
    {
    }
    public static function smartyStringFetch(&$smarty, $content)
    {
        $smarty->compile_id = md5($content . time());
        try {
            if(defined("Smarty::SMARTY_VERSION")) {
                $ver = str_replace("Smarty-", "", $smarty::SMARTY_VERSION);
                $versioncheck = version_compare("3.0.0", $ver, "<");
            } else {
                $versioncheck = false;
            }
        } catch (\Exception $ex) {
            $versioncheck = false;
        }
        if($versioncheck) {
            $result = $smarty->fetch("string:" . $content);
        } else {
            self::registerResources($smarty);
            $uid = uniqid();
            $smarty->assign($uid, $content);
            $result = $smarty->fetch("fromstr:" . $uid);
            $smarty->unregister_resource("fromstr");
        }
        return $result;
    }
}

?>