<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
namespace mgCRM2\Services;

/**
 * @important: this class in order to work with WHMCS API
 * HAVE TO BE executed with $SKIP_WHMCS = false (whole request have to implement whmcs at start)
 * only then global variable $whmcs will be visible (its used by localAPI command)
 */
class WhmcsApi
{
    /**
     * Keep single instance of translation object
     * We do not want to create many many translators object's
     *
     * @var WhmcsApi instance
     */
    private static $instance;
    /**
     * base possibility
     *
     * @var array
     */
    private static $config;
    private function __construct()
    {
        self::$instance = $this;
    }
    private function __clone()
    {
    }
    public static function getInstance()
    {
        if(self::$instance) {
            $class = get_called_class();
            self::$instance = new $class();
        }
        return self::$instance;
    }
    public function addTicketReplyFromAdmin($ticketID, $message)
    {
        $values = ["ticketid" => $ticketID, "adminusername" => sprintf("%s %s", \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->firstname, \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->lastname), "message" => $message];
        $results = localAPI("addticketreply", $values, \mgCRM2\Integration\Slim\SlimApp::getInstance()->currentAdmin->username);
        if($results["result"] == "success") {
            return true;
        }
        return $results;
    }
    public function triggerNotificationEvent($title, $message, $status = "info", $url = NULL)
    {
        $data = ["notification_identifier" => "crm.email.new", "title" => $title, "message" => $message, "statusStyle" => $status, "url" => $url];
        $result = localApi("TriggerNotificationEvent", $data);
        if($result["result"] === "success") {
            return true;
        }
        return $result;
    }
}

?>