<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 74.
if(!function_exists("array_filter_recursive")) {
    function array_filter_recursive(&$array)
    {
        foreach ($array as $key => $item) {
            $array[$key] = array_filter_recursive($item);
            is_array($item) && $array[$key];
            if(empty($array[$key])) {
                unset($array[$key]);
            }
        }
        return $array;
    }
}
if(!function_exists("file_upload_max_size")) {
    function file_upload_max_size($isConvertToBit = true)
    {
        $post_max_size_string = ini_get("post_max_size");
        $upload_max_string = ini_get("upload_max_filesize");
        $post_max_size = parse_size($post_max_size_string);
        $upload_max = parse_size($upload_max_string);
        if(0 < $post_max_size && $post_max_size <= $upload_max) {
            return $isConvertToBit ? $post_max_size : $post_max_size_string;
        }
        if(0 < $upload_max && $upload_max < $post_max_size) {
            return $isConvertToBit ? $upload_max : $upload_max_string;
        }
    }
}
if(!function_exists("parse_size")) {
    function parse_size($size)
    {
        $unit = preg_replace("/[^bkmgtpezy]/i", "", $size);
        $size = preg_replace("/[^0-9\\.]/", "", $size);
        if($unit) {
            return round($size * pow(1024, stripos("bkmgtpezy", strtolower($unit[0]))));
        }
        return round($size);
    }
}
if(!function_exists("include_whmcs")) {
    function include_whmcs()
    {
        $whmcsIncludePath = dirname(dirname(dirname(dirname(dirname(__FILE__))))) . DIRECTORY_SEPARATOR;
        if(file_exists($whmcsIncludePath . "init.php")) {
            if(!defined("ADMINAREA")) {
                define("ADMINAREA", true);
            }
            require_once $whmcsIncludePath . "init.php";
            global $whmcs;
            $whmcs = App::self();
        }
        if(file_exists($whmcsIncludePath . "includes" . DIRECTORY_SEPARATOR . "functions.php")) {
            require_once $whmcsIncludePath . "includes" . DIRECTORY_SEPARATOR . "functions.php";
        }
    }
}
if(!function_exists("get_coutry_dir")) {
    function get_coutry_dir()
    {
        include_whmcs();
        $whmcsIncludePath = dirname(dirname(dirname(dirname(dirname(__FILE__))))) . DIRECTORY_SEPARATOR;
        $countryFile = $whmcsIncludePath . (version_compare($GLOBALS["CONFIG"]["Version"], "7.0.0", ">=") ? "resources/country/dist.countries.json" : "includes/countries.php");
        return ["dir" => $countryFile, "type" => version_compare($GLOBALS["CONFIG"]["Version"], "7.0.0", ">=") ? "json" : "php"];
    }
}
if(!function_exists("object_to_array")) {
    function object_to_array($data)
    {
        if(is_array($data) || is_object($data)) {
            $result = [];
            foreach ($data as $key => $value) {
                $result[$key] = object_to_array($value);
            }
            return $result;
        } else {
            return $data;
        }
    }
}
if(!function_exists("array_flat")) {
    function array_flat($array, $prefix = "")
    {
        $result = [];
        foreach ($array as $key => $value) {
            if(is_array($value)) {
                $result = $result + array_flat($value, $prefix . $key . ".");
            } else {
                $result[$prefix . $key] = $value;
            }
        }
        return $result;
    }
}
if(!function_exists("pre_print")) {
    function pre_print($var, $title = "", $return = false)
    {
        $output = "";
        $output .= $title ? "<strong>" . $title . "</strong>" : "";
        $output .= "<pre>";
        $output .= print_r($var, true);
        $output .= "</pre>";
        if($return) {
            return $output;
        }
        echo $output;
    }
}
if(!function_exists("size_format")) {
    function size_format($bytes, $decimals = 0)
    {
        $bytes = (double) $bytes;
        if($bytes < 1000) {
            return $bytes . " B";
        }
        if($bytes < pow(1000, 2)) {
            return number_format($bytes / 1000, $decimals, ".", "") . " KB";
        }
        if($bytes < pow(1000, 3)) {
            return number_format($bytes / pow(1000, 2), $decimals, ".", "") . " MB";
        }
        if($bytes < pow(1000, 4)) {
            return number_format($bytes / pow(1000, 3), $decimals, ".", "") . " GB";
        }
        if($bytes < pow(1000, 5)) {
            return number_format($bytes / pow(1000, 4), $decimals, ".", "") . " TB";
        }
        if($bytes < pow(1000, 6)) {
            return number_format($bytes / pow(1000, 5), $decimals, ".", "") . " PB";
        }
        return number_format($bytes / pow(1000, 5), $decimals, ".", "") . " PB";
    }
}
if(!function_exists("str_to_bool")) {
    function str_to_bool($string, $default = false)
    {
        $yes_words = "affirmative|all right|aye|indubitably|most assuredly|ok|of course|okay|sure thing|y|yes+|yea|yep|sure|yeah|true|t|on|1|oui|vrai";
        $no_words = "no*|no way|nope|nah|na|never|absolutely not|by no means|negative|never ever|false|f|off|0|non|faux";
        if(preg_match("/^(" . $yes_words . ")\$/i", $string)) {
            return true;
        }
        if(preg_match("/^(" . $no_words . ")\$/i", $string)) {
            return false;
        }
        return $default;
    }
}
if(!function_exists("strip_space")) {
    function strip_space($string)
    {
        return preg_replace("/\\s+/", "", $string);
    }
}
if(!function_exists("full_permissions")) {
    function full_permissions($file, $perms = NULL)
    {
        if(is_null($perms)) {
            if(!file_exists($file)) {
                return false;
            }
            $perms = fileperms($file);
        }
        if(($perms & 49152) == 49152) {
            $info = "s";
        } elseif(($perms & 40960) == 40960) {
            $info = "l";
        } elseif(($perms & 32768) == 32768) {
            $info = "-";
        } elseif(($perms & 24576) == 24576) {
            $info = "b";
        } elseif(($perms & 16384) == 16384) {
            $info = "d";
        } elseif(($perms & 8192) == 8192) {
            $info = "c";
        } elseif(($perms & 4096) == 4096) {
            $info = "p";
        } else {
            $info = "u";
        }
        $info .= $perms & 256 ? "r" : "-";
        $info .= $perms & 128 ? "w" : "-";
        $info .= $perms & 64 ? $perms & 2048 ? "s" : "x" : ($perms & 2048 ? "S" : "-");
        $info .= $perms & 32 ? "r" : "-";
        $info .= $perms & 16 ? "w" : "-";
        $info .= $perms & 8 ? $perms & 1024 ? "s" : "x" : ($perms & 1024 ? "S" : "-");
        $info .= $perms & 4 ? "r" : "-";
        $info .= $perms & 2 ? "w" : "-";
        $info .= $perms & 1 ? $perms & 512 ? "t" : "x" : ($perms & 512 ? "T" : "-");
        return $info;
    }
}
if(!function_exists("array_flip_keys_by")) {
    function array_flip_keys_by(array &$array, $key)
    {
        if(is_null($key) || trim($key) == "") {
            return $array;
        }
        return array_combine(array_map(function ($item) {
            return is_object($item) ? object_get($item, $key) : array_get($item, $key);
        }, $array), $array);
    }
}

?>