/***************************************************************************************
 *
 * 
 *                  ██████╗██████╗ ███╗   ███╗         Customer
 *                 ██╔════╝██╔══██╗████╗ ████║         Relations
 *                 ██║     ██████╔╝██╔████╔██║         Manager
 *                 ██║     ██╔══██╗██║╚██╔╝██║
 *                 ╚██████╗██║  ██║██║ ╚═╝ ██║         For WHMCS
 *                  ╚═════╝╚═╝  ╚═╝╚═╝     ╚═╝
 * 
 *    
 * @author      Piotr Sarzyński <piotr.sa@modulesgarden.com> 
 *              
 *                           
 * @link        http://www.docs.modulesgarden.com/CRM_For_WHMCS for documenation
 * @link        http://modulesgarden.com ModulesGarden
 *              Top Quality Custom Software Development
 * @copyright   Copyright (c) ModulesGarden, INBS Group Brand, 
 *              All Rights Reserved (http://modulesgarden.com)
 * 
 * This software is furnished under a license and mxay be used and copied only  in  
 * accordance  with  the  terms  of such  license and with the inclusion of the above 
 * copyright notice.  This software  or any other copies thereof may not be provided 
 * or otherwise made available to any other person.  No title to and  ownership of 
 * the  software is hereby transferred.
 *
 **************************************************************************************/

angular.module("mgCRMapp").controller(
        'exportCtrl',
        ['$scope', '$rootScope', '$state', '$stateParams', '$http', 'ngDialog', 'AclService',
function( $scope,   $rootScope,   $state,   $stateParams,   $http,   ngDialog,   AclService)
{
    $scope.isZip = true;
    
    function getIsZip() {
        $http.get($rootScope.settings.config.apiURL + '/importexport/export/iszip/json', {
            cache: true,
        }).then(function(result) 
        {
            
            $scope.isZip = result.data.isZip;
        });
    }
    getIsZip();
    
    $scope.exportType = 'csv';
    $scope.url = $rootScope.settings.config.apiURL + '/importexport/export/' + $scope.exportType;

    var changerTypeWacher = $scope.$watch('exportType', function(newVal, oldVal) {
        if(newVal == null && oldVal == null || newVal ==  oldVal) { return;}
        
        $scope.url = $rootScope.settings.config.apiURL + '/importexport/export/' + newVal;
    });

    /////////////////////////////
    // CLEANERS
    // when scope will be destroned, to avoid memory leaks
    // clear watchers/timeouts/intervals etc
    /////////////////////////////
    $scope.$on('$destroy', function () {
        // since we use watcher to check if priority has been changed
        changerTypeWacher();
    });
}]);